/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.CompilationUnitBuilder;
import apex.jorje.data.ast.Identifier;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.member.PropertyInfo;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierGroups;
import apex.jorje.semantic.ast.modifier.SharingType;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.type.ArgumentTypeInfos;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.semantic.tester.EmptySymbolProvider;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import apex.jorje.semantic.tester.TestQueryValidators;
import apex.jorje.semantic.tester.TestSymbolResolvers;
import apex.jorje.services.Version;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockTestCase;
import org.powermock.reflect.Whitebox;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import shaded.org.objectweb.asm.AnnotationVisitor;
import shaded.org.objectweb.asm.ClassWriter;
import shaded.org.objectweb.asm.FieldVisitor;

@PrepareForTest(value={ClassWriter.class, FieldVisitor.class})
public class AdditionalInfoTest
extends PowerMockTestCase {
    private static final List<TypeInfo> ARGUMENT_TYPES = ImmutableList.of(ArgumentTypeInfos.T);
    @Mock
    private ClassWriter classWriter;
    @Mock
    private FieldVisitor fieldVisitor;
    @Mock
    private CodeUnitDetails codeUnitDetails;
    @Mock
    private GenericTypeInfo type;
    @Mock
    private ParentTable parents;
    @Mock
    private Emitter emitter;
    @Mock
    private SourceFile source;
    private AdditionalInfo additionalInfo;
    private List<Compilation> innerTypes;
    private List<Property> properties;
    private TypeInfo superType;
    private Set<TypeInfo> interfaces;
    private TypeStack.TypeContext context;
    private TypeStack typeStack;
    @Mock
    private AnnotationVisitor annotationVisitor;
    private TestAccessEvaluator accessEvaluator;

    @BeforeMethod
    public void setUp() throws Exception {
        this.accessEvaluator = new TestAccessEvaluator();
        this.accessEvaluator.setHasApexGenericType(true);
        this.innerTypes = new ArrayList<Compilation>();
        this.properties = new ArrayList<Property>();
        Mockito.when((Object)this.codeUnitDetails.getType()).thenReturn((Object)this.type);
        Mockito.when(this.type.accept((TypeInfoVisitor)Matchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.type.getRootUnreifiedType()).thenReturn((Object)this.type);
        Mockito.when((Object)((Object)this.type.getUnitType())).thenReturn((Object)UnitType.CLASS);
        Mockito.when((Object)this.type.getModifiers()).thenReturn((Object)ModifierGroups.STATEMENT_EXECUTED);
        Mockito.when((Object)this.type.parents()).thenReturn((Object)this.parents);
        Mockito.when((Object)this.type.getNamespace()).thenReturn((Object)Namespaces.EMPTY);
        Mockito.when((Object)this.type.getCodeUnitDetails()).thenReturn((Object)this.codeUnitDetails);
        Mockito.when((Object)this.codeUnitDetails.getName()).thenReturn((Object)"ApexBaseClass");
        Mockito.when((Object)this.codeUnitDetails.getSource()).thenReturn((Object)this.source);
        this.superType = TypeInfos.OBJECT;
        this.interfaces = new HashSet<TypeInfo>();
        Mockito.stub((Object)this.type.getBytecodeName()).toReturn((Object)InternalTypeInfos.APEX_OBJECT.getBytecodeName());
        Mockito.stub((Object)this.type.getApexName()).toReturn((Object)InternalTypeInfos.APEX_OBJECT.getApexName());
        Method visitField = Whitebox.getMethod(ClassWriter.class, (String)"visitField", (Class[])new Class[]{Integer.TYPE, String.class, String.class, String.class, Object.class});
        PowerMockito.doReturn((Object)this.fieldVisitor).when((Object)this.classWriter, visitField).withArguments((Object)Mockito.anyInt(), new Object[]{Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.any()});
        PowerMockito.when((Object)this.classWriter, (String)"visitAnnotation", (Object[])new Object[]{InternalTypeInfos.SFDC_ADDITIONAL_TYPE.getTypeSignature(), true}).thenReturn((Object)this.annotationVisitor);
        this.typeStack = new TypeStack();
        Mockito.when((Object)this.emitter.getTypeStack()).thenReturn((Object)this.typeStack);
    }

    private void init(TypeInfo type) {
        Mockito.when((Object)this.parents.isResolved()).thenReturn((Object)true);
        Mockito.when((Object)this.parents.superType()).thenReturn((Object)this.superType);
        Mockito.when(this.parents.immediateInterfaces()).thenReturn(this.interfaces);
        this.context = TypeStack.TypeContext.builder().setType(type).setClassWriter(this.classWriter).build();
        this.typeStack.push(this.context);
        this.additionalInfo = AdditionalInfo.builder().setDefiningType(type).setInnerTypes(this.innerTypes).setProperties(this.properties).build();
    }

    private void verifyVisit(String ... interfaces) {
        ((ClassWriter)Mockito.verify((Object)this.classWriter, (VerificationMode)Mockito.times((int)1))).visit(196653, ModifierGroups.STATEMENT_EXECUTED.getJavaModifiers() | 0x20, this.type.getBytecodeName(), null, this.superType.getBytecodeName(), interfaces);
    }

    private void verifyVisitField(String fieldName, String value) {
        ((ClassWriter)Mockito.verify((Object)this.classWriter, (VerificationMode)Mockito.times((int)1))).visitField(26, fieldName, TypeInfos.STRING.getTypeSignature(), null, value);
        ((FieldVisitor)Mockito.verify((Object)this.fieldVisitor, (VerificationMode)Mockito.times((int)1))).visitEnd();
    }

    private void verifyNoVisitField() {
        ((ClassWriter)Mockito.verify((Object)this.classWriter, (VerificationMode)Mockito.times((int)0))).visitField(Mockito.anyInt(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.any());
        ((FieldVisitor)Mockito.verify((Object)this.fieldVisitor, (VerificationMode)Mockito.times((int)0))).visitEnd();
    }

    private void walk() {
        StandardSymbolResolver symbols = TestSymbolResolvers.createTestSymbols(EmptySymbolProvider.get(), this.accessEvaluator, new TestQueryValidators.Noop());
        Errors errors = new Errors();
        this.additionalInfo.validate(symbols, new ValidationScope(symbols, errors));
        errors.throwIfAny();
        this.additionalInfo.emit(this.emitter);
    }

    @Test
    public void testEmptyClass() {
        this.init(this.type);
        this.walk();
        this.verifyVisit(new String[0]);
        this.verifyNoVisitField();
    }

    @Test
    public void testExtendClass() {
        Object type = ((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"ApexBaseClass"))).setApexBytecodeName(InternalTypeInfos.APEX_OBJECT.getBytecodeName())).setParents(this.parents)).buildResolved();
        this.superType = TypeInfos.DATE;
        this.init((TypeInfo)type);
        this.walk();
        this.verifyNoVisitField();
        this.verifyVisit(new String[0]);
    }

    @Test
    public void testEmitGenericTypesForClasses() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"ApexBaseClass"))).setApexBytecodeName(InternalTypeInfos.APEX_OBJECT.getBytecodeName())).setModifiers(ModifierGroups.GLOBAL)).setParents(this.parents)).setTypeArguments(ARGUMENT_TYPES).buildResolved();
        this.interfaces.add(GenericTypeInfoFactory.create((TypeInfo)type, TypeInfos.INTEGER));
        this.interfaces.add(TypeInfos.BOOLEAN);
        this.init(type);
        this.walk();
        this.verifyVisitField("__sfdcParameterizedTypes", "System/ApexBaseClass@java/lang/Integer,java/lang/Boolean@");
        this.verifyVisit(type.getBytecodeName(), TypeInfos.BOOLEAN.getBytecodeName());
    }

    @Test
    public void testDoNotEmitGenericTypesForClassesIfNone() {
        this.interfaces.add(TypeInfos.STRING);
        this.interfaces.add(TypeInfos.BOOLEAN);
        Mockito.when((Object)((Object)this.type.getUnitType())).thenReturn((Object)UnitType.CLASS);
        this.init(this.type);
        this.walk();
        this.verifyNoVisitField();
        this.verifyVisit(TypeInfos.BOOLEAN.getBytecodeName(), TypeInfos.STRING.getBytecodeName());
    }

    @Test
    public void testDoNotEmitGenericTypesForInterfaces() {
        GenericTypeInfo type = ((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)((GenericTypeInfo.Builder)GenericTypeInfo.builder().setFileBase(this.source, CompilationUnitBuilder.emptyClass((String)"ApexBaseClass"))).setApexBytecodeName(InternalTypeInfos.APEX_OBJECT.getBytecodeName())).setModifiers(ModifierGroups.GLOBAL)).setUnitType(UnitType.INTERFACE)).setParents(this.parents)).setTypeArguments(ARGUMENT_TYPES).setBasicType(BasicType.APEX_OBJECT)).buildResolved();
        this.interfaces.add(GenericTypeInfoFactory.create((TypeInfo)type, TypeInfos.INTEGER));
        this.interfaces.add(TypeInfos.BOOLEAN);
        Mockito.when((Object)((Object)this.source.getVersion())).thenReturn((Object)Version.CURRENT);
        Mockito.when((Object)this.codeUnitDetails.getSource()).thenReturn((Object)this.source);
        this.init(type);
        this.walk();
        this.verifyNoVisitField();
        this.verifyVisit(type.getBytecodeName(), TypeInfos.BOOLEAN.getBytecodeName());
    }

    private Compilation createInnerType(TypeInfo enclosingType, String name) {
        Compilation unit = (Compilation)Mockito.mock(Compilation.class);
        CompilationOutput output = (CompilationOutput)Mockito.mock(CompilationOutput.class);
        TypeInfo innerType = (TypeInfo)Mockito.mock(TypeInfo.class);
        String apexName = enclosingType.getApexName() + "." + name;
        Mockito.when((Object)innerType.getApexName()).thenReturn((Object)apexName);
        Mockito.when((Object)unit.getOutput()).thenReturn((Object)output);
        Mockito.when((Object)output.getType()).thenReturn((Object)innerType);
        return unit;
    }

    @Test
    public void testEmitInnerTypes() {
        this.innerTypes.add(this.createInnerType(this.type, "Foo"));
        this.innerTypes.add(this.createInnerType(this.type, "Bar"));
        this.init(this.type);
        this.walk();
        this.verifyVisitField("__sfdcInnerTypes", "Bar,Foo");
        this.verifyVisit(new String[0]);
    }

    private Property createProperty(String encoding) {
        Property property = (Property)Mockito.mock(Property.class);
        PropertyInfo info = (PropertyInfo)Mockito.mock(PropertyInfo.class);
        Mockito.when((Object)property.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)info.encode()).thenReturn((Object)encoding);
        Mockito.when((Object)info.getName()).thenReturn((Object)new Identifier(null, encoding));
        return property;
    }

    @Test
    public void testEmitProperties() {
        this.properties.add(this.createProperty("encoding1"));
        this.properties.add(this.createProperty("encoding2"));
        this.init(this.type);
        this.walk();
        this.verifyVisitField("__sfdcProperties", "H4sIAAAAAAAAAFvzloG1hEE4NS85PyUzL91QB8YyAgDu9OJiGgAAAA==");
        this.verifyVisit(new String[0]);
    }

    @Test
    public void testEmitAdditionalCodeLocations() {
        this.init(this.type);
        this.context.addAdditionalCodeLocation(1);
        this.context.addAdditionalCodeLocation(2);
        this.context.addAdditionalCodeLocation(7);
        this.context.addAdditionalCodeLocation(9);
        this.walk();
        this.verifyVisitField("_sfdcAdditionalCodeLocations", "1,2,7,9");
        this.verifyVisit(new String[0]);
    }

    @Test
    public void testEmitSuppressedCodeLocations() {
        this.init(this.type);
        this.context.addSuppressedCodeLocation(1);
        this.context.addSuppressedCodeLocation(2);
        this.context.addSuppressedCodeLocation(7);
        this.context.addSuppressedCodeLocation(9);
        this.walk();
        this.verifyVisitField("_sfdcSuppressedCodeLocations", "1,2,7,9");
        this.verifyVisit(new String[0]);
    }

    @Test
    public void testVisit() {
        Mockito.when((Object)((Object)this.type.getUnitType())).thenReturn((Object)UnitType.ANNOTATION);
        Mockito.when((Object)this.type.getModifiers()).thenReturn((Object)ModifierGroup.builder().addModifiers(ModifierTypeInfos.WITH_SHARING).build());
        Mockito.when((Object)this.source.getAllPackageId()).thenReturn((Object)"allPackageId");
        this.init(this.type);
        this.walk();
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)1))).visit("pacAllPackageId", "allPackageId");
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)1))).visit("withSharingType", SharingType.WITH.name());
    }

    @Test
    public void testSharingTypeInheritNotVisited() {
        Mockito.when((Object)((Object)this.type.getUnitType())).thenReturn((Object)UnitType.ANNOTATION);
        Mockito.when((Object)this.type.getModifiers()).thenReturn((Object)ModifierGroups.STATEMENT_EXECUTED);
        this.init(this.type);
        this.walk();
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)0))).visit((String)Mockito.eq((Object)"pacAllPackageId"), Mockito.any());
        ((AnnotationVisitor)Mockito.verify((Object)this.annotationVisitor, (VerificationMode)Mockito.times((int)0))).visit((String)Mockito.eq((Object)"withSharingType"), Mockito.any());
    }
}

