/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.jorje.data.Loc;
import apex.jorje.data.errors.SyntaxError;
import apex.jorje.data.errors.UserError;
import apex.jorje.parser.impl.CustomRecognitionException;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.MyInterner;
import apex.jorje.services.Version;
import com.google.common.base.Strings;

class StringToken {
    StringToken() {
    }

    public static String escape(Loc loc, String input, Version version, boolean isLike) throws CustomRecognitionException {
        if (Strings.isNullOrEmpty(input)) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        int length = input.length();
        int curr = 0;
        int copyFrom = 0;
        int index = input.indexOf(92, curr);
        while (index != -1) {
            if (index >= length - 1) {
                SyntaxError error = SyntaxError._IllegalStringLiteral(loc, I18nSupport.getLabel("invalid.string.literal.illegal.last.character", input));
                throw new CustomRecognitionException(UserError._Syntax(error));
            }
            char next = input.charAt(index + 1);
            switch (next) {
                case '%': 
                case '_': {
                    SyntaxError error;
                    if (!isLike) {
                        error = SyntaxError._IllegalStringLiteral(loc, I18nSupport.getLabel("invalid.string.literal.illegal.character.sequence", input, Character.valueOf(next)));
                        throw new CustomRecognitionException(UserError._Syntax(error));
                    }
                    curr = index + 2;
                    break;
                }
                case '\\': {
                    if (!isLike || version.isLessThan(Version.V172)) {
                        builder.append(input.substring(copyFrom, index));
                        builder.append('\\');
                        curr = copyFrom = index + 2;
                        break;
                    }
                    curr = index + 2;
                    break;
                }
                case 'U': 
                case 'u': {
                    SyntaxError error;
                    if (length < index + 6) {
                        error = SyntaxError._IllegalStringLiteral(loc, I18nSupport.getLabel("invalid.string.literal.illegal.unicode.sequence", input, input.substring(copyFrom, input.length())));
                        throw new CustomRecognitionException(UserError._Syntax(error));
                    }
                    String unicode = input.substring(index + 2, index + 6);
                    try {
                        builder.append(input.substring(copyFrom, index));
                        int value = Integer.parseInt(unicode, 16);
                        builder.append((char)value);
                        curr = copyFrom = index + 6;
                        break;
                    }
                    catch (NumberFormatException x) {
                        SyntaxError error2 = SyntaxError._IllegalStringLiteral(loc, I18nSupport.getLabel("invalid.string.literal.illegal.unicode", input, unicode));
                        throw new CustomRecognitionException(UserError._Syntax(error2));
                    }
                }
                case '\"': 
                case '\'': 
                case 'B': 
                case 'F': 
                case 'N': 
                case 'R': 
                case 'T': 
                case 'b': 
                case 'f': 
                case 'n': 
                case 'r': 
                case 't': {
                    builder.append(input.substring(copyFrom, index));
                    builder.append(StringToken.replacementChar(next));
                    curr = copyFrom = index + 2;
                    break;
                }
                default: {
                    SyntaxError error = SyntaxError._IllegalStringLiteral(loc, I18nSupport.getLabel("invalid.string.literal.illegal.character.sequence", input, Character.valueOf(next)));
                    throw new CustomRecognitionException(UserError._Syntax(error));
                }
            }
            index = input.indexOf(92, curr);
        }
        if (copyFrom > 0) {
            builder.append(input.substring(copyFrom));
            return MyInterner.intern(builder.toString());
        }
        return input;
    }

    private static char replacementChar(char next) {
        switch (next) {
            case 'N': 
            case 'n': {
                return '\n';
            }
            case 'R': 
            case 'r': {
                return '\r';
            }
            case 'T': 
            case 't': {
                return '\t';
            }
            case 'B': 
            case 'b': {
                return '\b';
            }
            case 'F': 
            case 'f': {
                return '\f';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        throw new IllegalArgumentException("illegal character: " + next);
    }
}

