/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.impl.session;

import apex.jorje.ide.db.api.operation.GraphOperations;
import apex.jorje.ide.db.impl.serialization.ObjectMapper;
import apex.jorje.ide.db.impl.session.MappingContext;
import com.tinkerpop.blueprints.Vertex;
import java.util.function.Function;

public class Session
implements ObjectMapper {
    private final ObjectMapper mapper;
    private final MappingContext mappingContext;

    public Session(ObjectMapper mapper) {
        this.mapper = mapper;
        this.mappingContext = new MappingContext();
    }

    @Override
    public <T> T deserialize(GraphOperations graph, Class<T> klass, Vertex vertex) {
        return (T)this.mappingContext.getVertexEntity(vertex.getId()).map(Function.identity()).orElseGet(() -> {
            Object entity = this.mapper.deserialize(graph, klass, vertex);
            this.mappingContext.registerVertexEntity(vertex.getId(), entity);
            return entity;
        });
    }

    @Override
    public <T> Vertex serialize(GraphOperations graph, Class<? extends T> klass, T entity) {
        return this.mapper.serialize(graph, klass, entity);
    }
}

