/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.impl.serialization;

import apex.jorje.data.Loc;
import apex.jorje.ide.db.api.entities.VirtualTypeInfo;
import apex.jorje.ide.db.api.operation.GraphOperations;
import apex.jorje.ide.db.impl.serialization.ObjectMapper;
import apex.jorje.ide.db.impl.serialization.Reflections;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import com.tinkerpop.blueprints.Vertex;
import java.lang.reflect.Method;

public class TypeInfoMapper
implements ObjectMapper.Mapper<TypeInfo> {
    public static final String TYPE_INFO_SIMPLE_NAME = TypeInfo.class.getSimpleName();
    public static final String APEX_NAME_KEY = TYPE_INFO_SIMPLE_NAME + "." + "apexName";

    @Override
    public TypeInfo deserialize(GraphOperations graph, Vertex vertex) {
        return new VirtualTypeInfo(graph, vertex);
    }

    @Override
    public Vertex serialize(GraphOperations graph, TypeInfo typeInfo) {
        String key = TYPE_INFO_SIMPLE_NAME + "." + "apexName";
        return graph.findOne(key, typeInfo.getApexName()).orElseGet(() -> this.serializeInternal(graph, typeInfo));
    }

    private Vertex serializeInternal(GraphOperations graph, TypeInfo typeInfo) {
        Vertex vertex = graph.addVertex("class:" + TypeInfo.class.getSimpleName());
        this.serializeBasicProperties(typeInfo, vertex);
        this.serializeParentTable(graph, typeInfo, vertex);
        this.serializeCodeUnitDetails(typeInfo, vertex);
        this.serializeSourceFileIfPossible(graph, typeInfo, vertex);
        return vertex;
    }

    private void serializeBasicProperties(TypeInfo typeInfo, Vertex vertex) {
        Reflections util = Reflections.INSTANCE;
        util.retrieveRelevantGetters(typeInfo).forEach(method -> vertex.setProperty(util.getKey((Method)method), util.getValue((Method)method, typeInfo)));
    }

    private void serializeParentTable(GraphOperations graph, TypeInfo typeInfo, Vertex vertex) {
        Vertex parent;
        ParentTable parentTable = typeInfo.parents();
        if (parentTable.superType() != null) {
            Vertex parent2 = graph.save(parentTable.superType(), TypeInfo.class);
            vertex.addEdge("SuperType", parent2);
        }
        for (TypeInfo implementee : typeInfo.parents().allInterfaces()) {
            parent = graph.save(implementee, TypeInfo.class);
            vertex.addEdge("AllInterfaces", parent);
        }
        for (TypeInfo implementee : typeInfo.parents().immediateInterfaces()) {
            parent = graph.save(implementee, TypeInfo.class);
            vertex.addEdge("ImmediateInterfaces", parent);
        }
    }

    private void serializeCodeUnitDetails(TypeInfo typeInfo, final Vertex vertex) {
        CodeUnitDetails codeUnitDetails = typeInfo.getCodeUnitDetails();
        vertex.setProperty("isApexSourceBased", codeUnitDetails.isApexSourceBased());
        vertex.setProperty("name", codeUnitDetails.getName());
        vertex.setProperty("isTrusted", codeUnitDetails.isTrusted());
        vertex.setProperty("isFileBased", codeUnitDetails.isFileBased());
        codeUnitDetails.getLoc()._switch(new Loc.SwitchBlock(){

            @Override
            public void _case(Loc.RealLoc loc) {
                vertex.setProperty("startIndex", loc.startIndex);
                vertex.setProperty("endIndex", loc.endIndex);
                vertex.setProperty("line", loc.line);
                vertex.setProperty("column", loc.column);
            }

            @Override
            public void _case(Loc.SyntheticLoc loc) {
            }
        });
    }

    private void serializeSourceFileIfPossible(GraphOperations graph, TypeInfo typeInfo, Vertex vertex) {
        if (typeInfo.getCodeUnitDetails().isApexSourceBased()) {
            SourceFile sourceFile = typeInfo.getCodeUnitDetails().getSource();
            Vertex sourceFileVertex = graph.save(sourceFile);
            vertex.addEdge("Source", sourceFileVertex);
        }
    }
}

