/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.impl.operation;

import apex.jorje.ide.db.api.operation.GraphOperations;
import apex.jorje.ide.db.impl.session.Session;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientTransactionalGraph;
import java.util.Optional;
import java.util.Set;

public class GraphTemplate
implements GraphOperations {
    private final Session session;
    private final OrientBaseGraph graph;

    public GraphTemplate(OrientBaseGraph graph, Session session) {
        this.graph = graph;
        this.session = session;
    }

    @Override
    public Optional<Vertex> findOne(String key, Object value) {
        Iterable<Vertex> vertices = this.graph.getVertices(key, value);
        return Optional.ofNullable(Iterables.getFirst(vertices, null));
    }

    @Override
    public <T> Vertex save(T entity) {
        return this.save(entity, entity.getClass());
    }

    @Override
    public <T> Vertex save(T entity, Class<? extends T> klass) {
        return this.session.serialize(this, klass, entity);
    }

    @Override
    public <T> T load(Vertex vertex, Class<? extends T> klass) {
        return this.session.deserialize(this, klass, vertex);
    }

    @Override
    public <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        return this.graph.createIndex(indexName, indexClass, indexParameters);
    }

    @Override
    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        return this.graph.getIndex(indexName, indexClass);
    }

    @Override
    public Iterable<Index<? extends Element>> getIndices() {
        return this.graph.getIndices();
    }

    @Override
    public void dropIndex(String indexName) {
        this.graph.dropIndex(indexName);
    }

    @Override
    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        this.graph.dropKeyIndex(key, elementClass);
    }

    @Override
    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, Parameter ... indexParameters) {
        this.graph.createKeyIndex(key, elementClass, indexParameters);
    }

    @Override
    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        return this.graph.getIndexedKeys(elementClass);
    }

    @Override
    public ODatabaseDocumentTx getRawGraph() {
        return this.graph.getRawGraph();
    }

    @Override
    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (this.graph instanceof OrientTransactionalGraph) {
            ((OrientTransactionalGraph)this.graph).stopTransaction(conclusion);
        }
    }

    @Override
    public void commit() {
        this.graph.commit();
    }

    @Override
    public void rollback() {
        this.graph.rollback();
    }

    @Override
    public Features getFeatures() {
        return this.graph.getFeatures();
    }

    @Override
    public Vertex addVertex(Object id) {
        return this.graph.addVertex(id);
    }

    @Override
    public Vertex getVertex(Object id) {
        return this.graph.getVertex(id);
    }

    @Override
    public void removeVertex(Vertex vertex) {
        this.graph.removeVertex(vertex);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return this.graph.getVertices();
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        return this.graph.getVertices(key, value);
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        return this.graph.addEdge(id, outVertex, inVertex, label);
    }

    @Override
    public Edge getEdge(Object id) {
        return this.graph.getEdge(id);
    }

    @Override
    public void removeEdge(Edge edge) {
        this.graph.removeEdge(edge);
    }

    @Override
    public Iterable<Edge> getEdges() {
        return this.graph.getEdges();
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        return this.graph.getEdges(key, value);
    }

    @Override
    public GraphQuery query() {
        return this.graph.query();
    }

    @Override
    public void shutdown() {
        this.graph.shutdown();
    }

    @Override
    public Iterable<Vertex> getVerticesOfClass(String iClassName) {
        return this.graph.getVerticesOfClass(iClassName);
    }

    @Override
    public long countVertices(String iClassName) {
        return this.graph.countVertices(iClassName);
    }

    @Override
    public Iterable<Vertex> queryVertices(String gremlinQuery) {
        return (Iterable)((Object)this.graph.command((OCommandRequest)new OCommandGremlin(gremlinQuery).execute(new Object[0])));
    }
}

