/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.impl;

import apex.jorje.ide.db.api.GraphDatabaseService;
import apex.jorje.ide.db.api.GraphHandleProvider;
import apex.jorje.ide.db.api.exception.SchemaInitializationException;
import apex.jorje.ide.db.api.operation.GraphOperations;
import apex.jorje.ide.db.impl.Configuration;
import apex.jorje.ide.db.impl.operation.GraphTemplate;
import apex.jorje.ide.db.impl.session.Session;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;

public final class StandardGraphDatabaseService
implements GraphDatabaseService {
    public static final StandardGraphDatabaseService INSTANCE = new StandardGraphDatabaseService(Configuration.DEFAULT);
    private final String graphStorage;
    private final String graphSchema;
    private final Session session;

    StandardGraphDatabaseService(Configuration configuration) {
        this.graphStorage = configuration.graphStorage;
        this.graphSchema = configuration.graphSchema;
        this.session = configuration.session;
    }

    @Override
    public GraphOperations getOrCreate(GraphHandleProvider handle) {
        OrientGraphFactory factory = new OrientGraphFactory(this.constructGraphUrl(handle));
        if (!factory.exists()) {
            this.initializeSchema(factory);
        }
        return new GraphTemplate(factory.getTx(), this.session);
    }

    @Override
    public GraphOperations getOrCreateNoTx(GraphHandleProvider handle) {
        OrientGraphFactory factory = new OrientGraphFactory(this.constructGraphUrl(handle));
        if (!factory.exists()) {
            this.initializeSchema(factory);
        }
        factory.declareIntent(new OIntentMassiveInsert());
        return new GraphTemplate(factory.getNoTx(), this.session);
    }

    @Override
    public boolean exists(GraphHandleProvider handle) {
        return new OrientGraphFactory(this.constructGraphUrl(handle)).exists();
    }

    @Override
    public void drop(GraphHandleProvider handle) {
        OrientGraphFactory factory = new OrientGraphFactory(this.constructGraphUrl(handle));
        if (factory.exists()) {
            factory.drop();
        }
    }

    private void initializeSchema(OrientGraphFactory factory) {
        OrientGraphNoTx noTx = factory.getNoTx();
        try {
            noTx.command(new OCommandScript("sql", this.graphSchema)).execute(new Object[0]);
        }
        catch (Exception e) {
            throw new SchemaInitializationException(e);
        }
        finally {
            noTx.shutdown();
        }
    }

    private String constructGraphUrl(GraphHandleProvider handle) {
        return String.format(this.graphStorage + "%s", handle.getHandle());
    }
}

