/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.ide.db.impl;

import apex.jorje.ide.db.impl.serialization.StandardObjectMapper;
import apex.jorje.ide.db.impl.session.Session;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;

public class Configuration {
    static final Configuration DEFAULT = new Builder().build();
    private static final String SCHEMA_SQL = "schema.sql";
    final String graphStorage;
    final String graphSchema;
    final Session session;

    private Configuration(Builder builder) {
        this.graphStorage = builder.graphStorage;
        this.graphSchema = builder.graphSchema;
        this.session = builder.session;
    }

    private static String generateSchema() {
        InputStream schema = Configuration.class.getClassLoader().getResourceAsStream(SCHEMA_SQL);
        try {
            return CharStreams.toString(new InputStreamReader(schema, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ String access$400() {
        return Configuration.generateSchema();
    }

    static class Builder {
        private static final String defaultGraphStorage = "plocal:";
        private static final String defaultGraphSchema = Configuration.access$400();
        private String graphStorage = "plocal:";
        private String graphSchema = defaultGraphSchema;
        private Session session = new Session(StandardObjectMapper.INSTANCE);

        private Builder() {
        }

        Builder setGraphSchema(String graphSchema) {
            this.graphSchema = graphSchema;
            return this;
        }

        Builder setGraphStorage(String graphStorage) {
            this.graphStorage = graphStorage;
            return this;
        }

        Builder setSession(Session session) {
            this.session = session;
            return this;
        }

        Configuration build() {
            return new Configuration(this);
        }
    }
}

