/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.TypeRef;

public abstract class PrefixOp {
    private PrefixOp() {
    }

    public static final PrefixOp _Positive(Loc loc) {
        return new Positive(loc);
    }

    public static final PrefixOp _Negative(Loc loc) {
        return new Negative(loc);
    }

    public static final PrefixOp _Not(Loc loc) {
        return new Not(loc);
    }

    public static final PrefixOp _BitwiseComplement(Loc loc) {
        return new BitwiseComplement(loc);
    }

    public static final PrefixOp _PrefixInc(Loc loc) {
        return new PrefixInc(loc);
    }

    public static final PrefixOp _PrefixDec(Loc loc) {
        return new PrefixDec(loc);
    }

    public static final PrefixOp _Cast(Loc loc, TypeRef type) {
        return new Cast(loc, type);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class Cast
    extends PrefixOp {
        public Loc loc;
        public TypeRef type;

        public Cast(Loc loc, TypeRef type) {
            this.loc = loc;
            this.type = type;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cast other = (Cast)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "Cast(loc = " + this.loc + ", type = " + this.type + ")";
        }
    }

    public static final class PrefixDec
    extends PrefixOp {
        public Loc loc;

        public PrefixDec(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrefixDec other = (PrefixDec)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "PrefixDec(loc = " + this.loc + ")";
        }
    }

    public static final class PrefixInc
    extends PrefixOp {
        public Loc loc;

        public PrefixInc(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrefixInc other = (PrefixInc)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "PrefixInc(loc = " + this.loc + ")";
        }
    }

    public static final class BitwiseComplement
    extends PrefixOp {
        public Loc loc;

        public BitwiseComplement(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BitwiseComplement other = (BitwiseComplement)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "BitwiseComplement(loc = " + this.loc + ")";
        }
    }

    public static final class Not
    extends PrefixOp {
        public Loc loc;

        public Not(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Not other = (Not)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "Not(loc = " + this.loc + ")";
        }
    }

    public static final class Negative
    extends PrefixOp {
        public Loc loc;

        public Negative(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Negative other = (Negative)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "Negative(loc = " + this.loc + ")";
        }
    }

    public static final class Positive
    extends PrefixOp {
        public Loc loc;

        public Positive(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Positive other = (Positive)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "Positive(loc = " + this.loc + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(Positive x) {
            this._default(x);
        }

        @Override
        public void _case(Negative x) {
            this._default(x);
        }

        @Override
        public void _case(Not x) {
            this._default(x);
        }

        @Override
        public void _case(BitwiseComplement x) {
            this._default(x);
        }

        @Override
        public void _case(PrefixInc x) {
            this._default(x);
        }

        @Override
        public void _case(PrefixDec x) {
            this._default(x);
        }

        @Override
        public void _case(Cast x) {
            this._default(x);
        }

        protected abstract void _default(PrefixOp var1);
    }

    public static interface SwitchBlock {
        public void _case(Positive var1);

        public void _case(Negative var1);

        public void _case(Not var1);

        public void _case(BitwiseComplement var1);

        public void _case(PrefixInc var1);

        public void _case(PrefixDec var1);

        public void _case(Cast var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(Positive x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(Negative x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(Not x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(BitwiseComplement x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(PrefixInc x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(PrefixDec x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(Cast x) {
            return this._default(x);
        }

        protected abstract ResultType _default(PrefixOp var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(Positive var1);

        public ResultType _case(Negative var1);

        public ResultType _case(Not var1);

        public ResultType _case(BitwiseComplement var1);

        public ResultType _case(PrefixInc var1);

        public ResultType _case(PrefixDec var1);

        public ResultType _case(Cast var1);
    }
}

