/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Loc;

public abstract class BinaryOp {
    private BinaryOp() {
    }

    public static final BinaryOp _Addition(Loc loc) {
        return new Addition(loc);
    }

    public static final BinaryOp _Subtraction(Loc loc) {
        return new Subtraction(loc);
    }

    public static final BinaryOp _Multiplication(Loc loc) {
        return new Multiplication(loc);
    }

    public static final BinaryOp _Division(Loc loc) {
        return new Division(loc);
    }

    public static final BinaryOp _LeftShift(Loc loc) {
        return new LeftShift(loc);
    }

    public static final BinaryOp _SignedRightShift(Loc loc) {
        return new SignedRightShift(loc);
    }

    public static final BinaryOp _UnsignedRightShift(Loc loc) {
        return new UnsignedRightShift(loc);
    }

    public static final BinaryOp _BitwiseXor(Loc loc) {
        return new BitwiseXor(loc);
    }

    public static final BinaryOp _BitwiseAnd(Loc loc) {
        return new BitwiseAnd(loc);
    }

    public static final BinaryOp _BitwiseOr(Loc loc) {
        return new BitwiseOr(loc);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class BitwiseOr
    extends BinaryOp {
        public Loc loc;

        public BitwiseOr(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BitwiseOr other = (BitwiseOr)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "BitwiseOr(loc = " + this.loc + ")";
        }
    }

    public static final class BitwiseAnd
    extends BinaryOp {
        public Loc loc;

        public BitwiseAnd(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BitwiseAnd other = (BitwiseAnd)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "BitwiseAnd(loc = " + this.loc + ")";
        }
    }

    public static final class BitwiseXor
    extends BinaryOp {
        public Loc loc;

        public BitwiseXor(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BitwiseXor other = (BitwiseXor)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "BitwiseXor(loc = " + this.loc + ")";
        }
    }

    public static final class UnsignedRightShift
    extends BinaryOp {
        public Loc loc;

        public UnsignedRightShift(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnsignedRightShift other = (UnsignedRightShift)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "UnsignedRightShift(loc = " + this.loc + ")";
        }
    }

    public static final class SignedRightShift
    extends BinaryOp {
        public Loc loc;

        public SignedRightShift(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SignedRightShift other = (SignedRightShift)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "SignedRightShift(loc = " + this.loc + ")";
        }
    }

    public static final class LeftShift
    extends BinaryOp {
        public Loc loc;

        public LeftShift(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LeftShift other = (LeftShift)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "LeftShift(loc = " + this.loc + ")";
        }
    }

    public static final class Division
    extends BinaryOp {
        public Loc loc;

        public Division(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Division other = (Division)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "Division(loc = " + this.loc + ")";
        }
    }

    public static final class Multiplication
    extends BinaryOp {
        public Loc loc;

        public Multiplication(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Multiplication other = (Multiplication)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "Multiplication(loc = " + this.loc + ")";
        }
    }

    public static final class Subtraction
    extends BinaryOp {
        public Loc loc;

        public Subtraction(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Subtraction other = (Subtraction)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "Subtraction(loc = " + this.loc + ")";
        }
    }

    public static final class Addition
    extends BinaryOp {
        public Loc loc;

        public Addition(Loc loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Addition other = (Addition)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "Addition(loc = " + this.loc + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(Addition x) {
            this._default(x);
        }

        @Override
        public void _case(Subtraction x) {
            this._default(x);
        }

        @Override
        public void _case(Multiplication x) {
            this._default(x);
        }

        @Override
        public void _case(Division x) {
            this._default(x);
        }

        @Override
        public void _case(LeftShift x) {
            this._default(x);
        }

        @Override
        public void _case(SignedRightShift x) {
            this._default(x);
        }

        @Override
        public void _case(UnsignedRightShift x) {
            this._default(x);
        }

        @Override
        public void _case(BitwiseXor x) {
            this._default(x);
        }

        @Override
        public void _case(BitwiseAnd x) {
            this._default(x);
        }

        @Override
        public void _case(BitwiseOr x) {
            this._default(x);
        }

        protected abstract void _default(BinaryOp var1);
    }

    public static interface SwitchBlock {
        public void _case(Addition var1);

        public void _case(Subtraction var1);

        public void _case(Multiplication var1);

        public void _case(Division var1);

        public void _case(LeftShift var1);

        public void _case(SignedRightShift var1);

        public void _case(UnsignedRightShift var1);

        public void _case(BitwiseXor var1);

        public void _case(BitwiseAnd var1);

        public void _case(BitwiseOr var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(Addition x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(Subtraction x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(Multiplication x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(Division x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(LeftShift x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SignedRightShift x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(UnsignedRightShift x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(BitwiseXor x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(BitwiseAnd x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(BitwiseOr x) {
            return this._default(x);
        }

        protected abstract ResultType _default(BinaryOp var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(Addition var1);

        public ResultType _case(Subtraction var1);

        public ResultType _case(Multiplication var1);

        public ResultType _case(Division var1);

        public ResultType _case(LeftShift var1);

        public ResultType _case(SignedRightShift var1);

        public ResultType _case(UnsignedRightShift var1);

        public ResultType _case(BitwiseXor var1);

        public ResultType _case(BitwiseAnd var1);

        public ResultType _case(BitwiseOr var1);
    }
}

