/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.AnnotationParameter;
import apex.jorje.data.ast.AnnotationValue;
import apex.jorje.data.ast.DottedExpr;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.Modifier;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class JadtFactory {
    public static final String REQUEST = "Request";

    private JadtFactory() {
    }

    public static Expr.VariableExpr variableExpr(Optional<DottedExpr> dottedExpr, Identifier ... identifiers) {
        return new Expr.VariableExpr(dottedExpr, Arrays.asList(identifiers));
    }

    public static Modifier.Annotation annotationKeyValues(String name) {
        return new Modifier.Annotation(Loc._SyntheticLoc(), JadtFactory.identifier(name), Collections.emptyList());
    }

    public static Modifier.Annotation annotationKeyValues(String name, String ... keyValues) {
        assert (keyValues.length % 2 == 0) : "illegal key value pair list";
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < keyValues.length; i += 2) {
            String key = keyValues[i];
            String value = keyValues[i + 1];
            parameters.add(AnnotationParameter._AnnotationKeyValue(Loc._SyntheticLoc(), JadtFactory.identifier(key), AnnotationValue._StringAnnotationValue(Loc._SyntheticLoc(), value)));
        }
        return new Modifier.Annotation(Loc._SyntheticLoc(), JadtFactory.identifier(name), (List<AnnotationParameter>)((Object)parameters.build()));
    }

    public static Modifier.Annotation annotationWithString(String name, String value) {
        assert (value != null);
        return new Modifier.Annotation(Loc._SyntheticLoc(), JadtFactory.identifier(name), ImmutableList.of(AnnotationParameter._AnnotationString(Loc._SyntheticLoc(), value)));
    }

    public static Modifier.Annotation annotation(String name) {
        return new Modifier.Annotation(Loc._SyntheticLoc(), JadtFactory.identifier(name), Collections.emptyList());
    }

    public static List<Identifier> identifiers(String ... identifiers) {
        return Arrays.stream(identifiers).map(JadtFactory::identifier).collect(Collectors.toList());
    }

    public static Identifier identifier(String name) {
        return Identifier._Identifier(Loc._SyntheticLoc(), name);
    }
}

