/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.sosl;

import apex.common.base.MoreStrings;
import apex.jorje.data.sosl.SearchWithClauseValue;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import java.util.Optional;
import java.util.function.Function;

public class SearchWithValuePrinter
implements Printer<SearchWithClauseValue> {
    private static final Printer<SearchWithClauseValue> INSTANCE = new SearchWithValuePrinter();
    private static final Function<String, String> STRING_VALUE_FORMATTER = s -> Optional.ofNullable(s).map(s1 -> "'" + s1 + "'").orElse(null);
    private static final SearchWithClauseValue.MatchBlock<String> VALUE_MATCHER = new SearchWithClauseValue.MatchBlock<String>(){

        @Override
        public String _case(SearchWithClauseValue.SearchWithStringValue x) {
            assert (!x.values.isEmpty()) : "with clause must have non empty values";
            return x.values.size() == 1 ? "= " + (String)STRING_VALUE_FORMATTER.apply(x.values.get(0)) : "IN " + x.values.stream().map(STRING_VALUE_FORMATTER).collect(MoreStrings.ON_COMMA_AND_SPACE_ENCLOSING_PARENTHESISES);
        }

        @Override
        public String _case(SearchWithClauseValue.SearchWithTrueValue x) {
            return "= true";
        }

        @Override
        public String _case(SearchWithClauseValue.SearchWithFalseValue x) {
            return "= false";
        }
    };

    private SearchWithValuePrinter() {
    }

    public static Printer<SearchWithClauseValue> get() {
        return INSTANCE;
    }

    @Override
    public String print(SearchWithClauseValue x, PrintContext ctx) {
        return x.match(VALUE_MATCHER);
    }
}

