/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.common.base.WeakStringInterner;
import apex.jorje.data.soql.BindClause;
import apex.jorje.data.soql.FromClause;
import apex.jorje.data.soql.GroupByClause;
import apex.jorje.data.soql.LimitClause;
import apex.jorje.data.soql.OffsetClause;
import apex.jorje.data.soql.OrderByClause;
import apex.jorje.data.soql.Query;
import apex.jorje.data.soql.QueryOption;
import apex.jorje.data.soql.SelectClause;
import apex.jorje.data.soql.TrackingType;
import apex.jorje.data.soql.UpdateStatsClause;
import apex.jorje.data.soql.WhereClause;
import apex.jorje.data.soql.WithClause;
import apex.jorje.data.soql.WithIdentifier;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.ast.OptionalPrinter;
import apex.jorje.services.printers.soql.BindPrinter;
import apex.jorje.services.printers.soql.FromClausePrinter;
import apex.jorje.services.printers.soql.GroupByPrinter;
import apex.jorje.services.printers.soql.LimitPrinter;
import apex.jorje.services.printers.soql.OffsetPrinter;
import apex.jorje.services.printers.soql.OrderByPrinter;
import apex.jorje.services.printers.soql.QueryOptionPrinter;
import apex.jorje.services.printers.soql.SelectPrinter;
import apex.jorje.services.printers.soql.TrackingTypePrinter;
import apex.jorje.services.printers.soql.UpdateStatsOptionsPrinter;
import apex.jorje.services.printers.soql.WherePrinter;
import apex.jorje.services.printers.soql.WithIdentifierPrinter;
import apex.jorje.services.printers.soql.WithPrinter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class QueryPrinter
implements Printer<Query> {
    private static final Supplier<Printer<Query>> INSTANCE = Suppliers.memoize(() -> new QueryPrinter(SelectPrinter.get(), FromClausePrinter.get(), WherePrinter.get(), WithPrinter.get(), WithIdentifierPrinter.get(), GroupByPrinter.get(), OrderByPrinter.get(), LimitPrinter.get(), OffsetPrinter.get(), BindPrinter.get(), TrackingTypePrinter.get(), UpdateStatsOptionsPrinter.get(), QueryOptionPrinter.get()));
    private final Printer<SelectClause> selectClausePrinter;
    private final Printer<FromClause> fromClausePrinter;
    private final Printer<Optional<WhereClause>> optionalWhere;
    private final Printer<Optional<WithClause>> optionalWith;
    private final Printer<List<WithIdentifier>> withIdentifiers;
    private final Printer<Optional<GroupByClause>> optionalGroupBy;
    private final Printer<Optional<OrderByClause>> optionalOrderBy;
    private final Printer<Optional<LimitClause>> optionalLimit;
    private final Printer<Optional<OffsetClause>> optionalOffset;
    private final Printer<Optional<BindClause>> optionalBind;
    private final Printer<Optional<TrackingType>> optionalTrackingType;
    private final Printer<Optional<UpdateStatsClause>> optionalUpdateStatsOption;
    private final Printer<Optional<QueryOption>> optionalQueryOption;

    private QueryPrinter(Printer<SelectClause> selectClausePrinter, Printer<FromClause> fromClausePrinter, Printer<WhereClause> whereClausePrinter, Printer<WithClause> withClausePrinter, Printer<WithIdentifier> withIdentifiersPrinter, Printer<GroupByClause> groupByClausePrinter, Printer<OrderByClause> orderByClausePrinter, Printer<LimitClause> limitPrinter, Printer<OffsetClause> offsetPrinter, Printer<BindClause> bindClausePrinter, Printer<TrackingType> trackingTypePrinter, Printer<UpdateStatsClause> updateStatsOptionsPrinter, Printer<QueryOption> queryOptionPrinter) {
        this.selectClausePrinter = selectClausePrinter;
        this.fromClausePrinter = fromClausePrinter;
        this.optionalWhere = OptionalPrinter.create(whereClausePrinter, "", " ", "");
        this.optionalWith = OptionalPrinter.create(withClausePrinter, "", " ", "");
        this.withIdentifiers = ListPrinter.create(withIdentifiersPrinter, " ", " ", "");
        this.optionalGroupBy = OptionalPrinter.create(groupByClausePrinter, "", " ", "");
        this.optionalOrderBy = OptionalPrinter.create(orderByClausePrinter, "", " ", "");
        this.optionalLimit = OptionalPrinter.create(limitPrinter, "", " ", "");
        this.optionalOffset = OptionalPrinter.create(offsetPrinter, "", " ", "");
        this.optionalBind = OptionalPrinter.create(bindClausePrinter, "", " ", "");
        this.optionalTrackingType = OptionalPrinter.create(trackingTypePrinter, "", " ", "");
        this.optionalUpdateStatsOption = OptionalPrinter.create(updateStatsOptionsPrinter, "", " ", "");
        this.optionalQueryOption = OptionalPrinter.create(queryOptionPrinter, "", " ", "");
    }

    public static Supplier<Printer<Query>> get() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String print(Query x, PrintContext ctx) {
        try {
            ctx.pushQueryDepth();
            String string = WeakStringInterner.get().intern(this.selectClausePrinter.print(x.select, ctx) + " " + this.fromClausePrinter.print(x.from, ctx) + this.optionalWhere.print(x.where, ctx) + this.optionalWith.print(x.with, ctx) + (x.withIdentifiers.isEmpty() ? "" : " ") + x.withIdentifiers.stream().map(withIdentifier -> WithIdentifierPrinter.get().print((WithIdentifier)withIdentifier, ctx)).collect(Collectors.joining(" ")) + this.optionalGroupBy.print(x.groupBy, ctx) + this.optionalOrderBy.print(x.orderBy, ctx) + this.optionalLimit.print(x.limit, ctx) + this.optionalOffset.print(x.offset, ctx) + this.optionalBind.print(x.bind, ctx) + this.optionalTrackingType.print(x.tracking, ctx) + this.optionalUpdateStatsOption.print(x.updateStats, ctx) + this.optionalQueryOption.print(x.options, ctx));
            return string;
        }
        finally {
            ctx.popQueryDepth();
        }
    }
}

