/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.data.ast.VersionRef;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.ExprPrecedenceComparator;
import java.util.Objects;
import java.util.Optional;

public class ExprPrinter
implements Printer<Expr> {
    private final PrinterFactory factory;

    public ExprPrinter(PrinterFactory factory) {
        this.factory = factory;
    }

    private String printDottedExpr(Optional<Expr> x, PrintContext ctx) {
        return x.map(expr -> this.bracket((Expr)expr, ExprPrecedenceComparator.INSTANCE.score((Expr)expr), false, ctx) + ".").orElse("");
    }

    @Override
    public String print(Expr x, final PrintContext ctx) {
        final Integer score = ExprPrecedenceComparator.INSTANCE.score(x);
        return x.match(new Expr.MatchBlock<String>(){

            @Override
            public String _case(Expr.AssignmentExpr x) {
                return ExprPrinter.this.bracket(x.left, score, true, ctx) + " " + (Object)((Object)x.op) + " " + ExprPrinter.this.bracket(x.right, score, false, ctx);
            }

            @Override
            public String _case(Expr.TernaryExpr x) {
                return ExprPrinter.this.bracket(x.condition, score, true, ctx) + " ? " + ExprPrinter.this.bracket(x.trueExpr, score, false, ctx) + " : " + ExprPrinter.this.bracket(x.falseExpr, score, false, ctx);
            }

            @Override
            public String _case(Expr.PrefixExpr x) {
                return (Object)((Object)x.op) + ExprPrinter.this.bracket(x.expr, score, false, ctx);
            }

            @Override
            public String _case(Expr.BinaryExpr x) {
                return ExprPrinter.this.bracket(x.left, score, true, ctx) + " " + (Object)((Object)x.op) + " " + ExprPrinter.this.bracket(x.right, score, false, ctx);
            }

            @Override
            public String _case(Expr.CastExpr x) {
                return "(" + ExprPrinter.this.factory.typeRefPrinter().print(x.type, ctx) + ")" + ExprPrinter.this.factory.exprPrinter().print(x.expr, ctx);
            }

            @Override
            public String _case(Expr.InstanceOf x) {
                return ExprPrinter.this.bracket(x.expr, score, true, ctx) + " instanceof " + ExprPrinter.this.factory.typeRefPrinter().print(x.type, ctx);
            }

            @Override
            public String _case(Expr.BooleanExpr x) {
                return ExprPrinter.this.bracket(x.left, score, true, ctx) + " " + (Object)((Object)x.op) + " " + ExprPrinter.this.bracket(x.right, score, false, ctx);
            }

            @Override
            public String _case(Expr.TriggerVariableExpr x) {
                return "Trigger." + ExprPrinter.this.factory.identifierPrinter().print(x.variable, ctx);
            }

            @Override
            public String _case(Expr.PackageVersionExpr x) {
                return "Package.Version." + x.version.match(new VersionRef.MatchBlock<String>(){

                    @Override
                    public String _case(VersionRef.StructuredVersion x) {
                        return x.major + "." + x.minor;
                    }

                    @Override
                    public String _case(VersionRef.RequestVersion x) {
                        return "Request";
                    }
                });
            }

            @Override
            public String _case(Expr.PostfixExpr x) {
                return ExprPrinter.this.bracket(x.expr, score, false, ctx) + (Object)((Object)x.op);
            }

            @Override
            public String _case(Expr.ArrayExpr x) {
                return ExprPrinter.this.bracket(x.expr, score, false, ctx) + "[" + ExprPrinter.this.print(x.index, ctx) + "]";
            }

            @Override
            public String _case(Expr.VariableExpr x) {
                return ExprPrinter.this.printDottedExpr(x.dottedExpr, ctx) + ExprPrinter.this.factory.dottedIdentifier().print(x.names, ctx);
            }

            @Override
            public String _case(Expr.MethodCallExpr x) {
                return ExprPrinter.this.printDottedExpr(x.dottedExpr, ctx) + ExprPrinter.this.factory.dottedIdentifier().print(x.names, ctx) + "(" + ExprPrinter.this.factory.exprListPrinter().print(x.inputParameters, ctx) + ")";
            }

            @Override
            public String _case(Expr.JavaMethodCallExpr x) {
                return "java : " + ExprPrinter.this.factory.dottedIdentifier().print(x.names, ctx) + "(" + ExprPrinter.this.factory.exprListPrinter().print(x.inputParameters, ctx) + ")";
            }

            @Override
            public String _case(Expr.JavaVariableExpr x) {
                return "java : " + ExprPrinter.this.factory.dottedIdentifier().print(x.names, ctx);
            }

            @Override
            public String _case(Expr.SuperMethodCallExpr x) {
                return "super(" + ExprPrinter.this.factory.exprListPrinter().print(x.inputParameters, ctx) + ")";
            }

            @Override
            public String _case(Expr.SuperVariableExpr x) {
                return "super";
            }

            @Override
            public String _case(Expr.ThisMethodCallExpr x) {
                return "this(" + ExprPrinter.this.factory.exprListPrinter().print(x.inputParameters, ctx) + ")";
            }

            @Override
            public String _case(Expr.ThisVariableExpr x) {
                return "this";
            }

            @Override
            public String _case(Expr.ClassRefExpr x) {
                return ExprPrinter.this.factory.typeRefPrinter().print(x.type, ctx) + ".class";
            }

            @Override
            public String _case(Expr.LiteralExpr x) {
                String value = Objects.toString(x.literal);
                if (x.type == LiteralType.STRING) {
                    return "'" + value + "'";
                }
                if (x.type == LiteralType.DOUBLE) {
                    return value + "D";
                }
                if (x.type == LiteralType.LONG) {
                    return value + "L";
                }
                return value;
            }

            @Override
            public String _case(Expr.NewExpr x) {
                return "new " + ExprPrinter.this.factory.newObjectPrinter().print(x.creator, ctx);
            }

            @Override
            public String _case(Expr.NestedExpr x) {
                return "( " + ExprPrinter.this.print(x.expr, ctx) + " )";
            }

            @Override
            public String _case(Expr.SoqlExpr x) {
                return "[" + ExprPrinter.this.factory.queryPrinter().print(x.query, ctx) + "]";
            }

            @Override
            public String _case(Expr.SoslExpr x) {
                return "[" + ExprPrinter.this.factory.searchPrinter().print(x.search, ctx) + "]";
            }
        });
    }

    private String bracket(Expr expr, Integer outerPrecedence, boolean bracketOnEquals, PrintContext ctx) {
        Integer innerPrecedence = ExprPrecedenceComparator.INSTANCE.score(expr);
        int comparison = innerPrecedence.compareTo(outerPrecedence);
        boolean needsBracket = comparison < 0 || comparison == 0 && bracketOnEquals;
        return needsBracket ? "(" + this.print(expr, ctx) + ")" : this.print(expr, ctx);
    }
}

