/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.visibility;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.semantic.symbol.visibility.legacy.LegacyVisibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import java.util.Optional;

public class VariableVisibility {
    public static Optional<String> calculateVisibilityError(AccessEvaluator accessEvaluator, AstNode referencingNode, Variable variable, Visibility.CheckType checkType, Visibility.ReferencedFromTestMethod referencedFromTestMethod, VariableVisitor.Context context) {
        boolean isMemberNotVisible;
        boolean isReferenceVisibleThroughLoophole;
        Version referencingTypeVersion = referencingNode.getDefiningType().getCodeUnitDetails().getVersion();
        Version variableVersion = variable.getDefiningType().getCodeUnitDetails().getVersion();
        boolean areLegacyRulesApplicable = referencingTypeVersion.isLessThanOrEqual(Version.COMPILER_RELEASE) && variableVersion.isLessThanOrEqual(Version.COMPILER_RELEASE);
        boolean bl = isReferenceVisibleThroughLoophole = areLegacyRulesApplicable && LegacyVisibility.isReferenceExpressionVisible(accessEvaluator, referencingNode, variable, referencedFromTestMethod, checkType, context);
        if (isReferenceVisibleThroughLoophole) {
            return Optional.empty();
        }
        boolean isPropertyVisibleThroughLoophole = areLegacyRulesApplicable && LegacyVisibility.isPropertyVisible(accessEvaluator, referencingNode, variable, referencedFromTestMethod, checkType);
        boolean bl2 = isMemberNotVisible = !isPropertyVisibleThroughLoophole && !Visibility.isMemberVariableVisible(accessEvaluator, referencingNode.getDefiningType(), variable, referencedFromTestMethod, checkType);
        if (isMemberNotVisible) {
            return Optional.of(I18nSupport.getLabel("variable.not.visible", variable.getDefiningType() + "." + variable.getName()));
        }
        if (areLegacyRulesApplicable && variable.getModifiers().has(ModifierTypeInfos.GLOBAL)) {
            return Optional.empty();
        }
        boolean isMemberTypeVisible = VariableVisibility.isVariableTypeVisible(accessEvaluator, referencingNode.getDefiningType(), variable, referencedFromTestMethod);
        return isMemberTypeVisible ? Optional.empty() : Optional.of(I18nSupport.getLabel("type.not.visible", variable.getType()));
    }

    private static boolean isVariableTypeVisible(AccessEvaluator accessEvaluator, TypeInfo referencingType, Variable variable, Visibility.ReferencedFromTestMethod referencedFromTestMethod) {
        return referencingType.getCodeUnitDetails().getVersion().isLessThan(Version.V158) || Visibility.isMemberTestVisible(accessEvaluator, referencingType, variable.getType(), variable.getModifiers(), referencedFromTestMethod) || Visibility.isTypeVisibleInImplicitReference(accessEvaluator, referencingType, variable.getType(), referencedFromTestMethod, Visibility.CheckGenericTypeArguments.NO);
    }
}

