/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.parent;

import apex.jorje.data.Locations;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.ParentTableCalculator;
import apex.jorje.semantic.symbol.type.parent.StandardParentTable;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreMaps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ParentTableFactory {
    private ParentTableFactory() {
    }

    public static ParentTable create(TypeInfo superType) {
        return ParentTableFactory.create(superType, ImmutableList.of());
    }

    public static ParentTable create(TypeInfo superType, List<TypeInfo> interfaces) {
        StandardParentTable table = new StandardParentTable();
        table.resolveSuperTypes(superType);
        table.resolveInterfaces(interfaces);
        return table;
    }

    public static void resolve(Multimap<TypeInfo, CompilationException> errors, SymbolResolver symbols, TypeInfo type) {
        ParentTableCalculator calculator = new ParentTableCalculator(errors, symbols);
        calculator.resolveSuperTypes(type);
        calculator.resolveInterfaces(type);
    }

    public static Collection<TypeInfo> getVersionedInterfaces(TypeInfo referencingType, TypeInfo type) {
        Map<String, StructuredVersion> interfaceVersions = MoreMaps.toEmptyMap(type.getCodeUnitDetails().getInterfacePackageVersions().get(Locations.toPair(type.getCodeUnitDetails().getLoc())));
        StructuredVersion theirVersion = referencingType.getCodeUnitDetails().getReferencedPackageVersions().get(type.getNamespace());
        return interfaceVersions.isEmpty() || theirVersion == null ? type.parents().allInterfaces() : Collections2.filter(type.parents().allInterfaces(), interfaceType -> {
            StructuredVersion ourVersion = (StructuredVersion)interfaceVersions.get(interfaceType.getApexName().toLowerCase());
            return ourVersion == null || theirVersion.compareTo(ourVersion) >= 0;
        });
    }
}

