/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.common.base.Initializers;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.JavaTypeMethodTableInitializer;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.JavaTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameFactory;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Objects;
import java.util.Set;

public class JavaTypeInfo
extends AbstractTypeInfo {
    private static final Set<String> MAPPED_TYPES = ImmutableSet.of(Boolean.class.getName(), TypeInfos.TIME.getBytecodeName().replace('/', '.'), TypeInfos.DATE.getBytecodeName().replace('/', '.'), Calendar.class.getName(), BigDecimal.class.getName(), Double.class.getName(), new String[]{Long.class.getName(), Integer.class.getName(), String.class.getName(), TypeInfos.ID.getBytecodeName().replace('/', '.'), TypeInfos.CURRENCY.getBytecodeName().replace('/', '.')});
    private final Class<?> clazz;

    private JavaTypeInfo(Builder builder) {
        super(builder);
        this.clazz = builder.clazz;
    }

    public static JavaTypeInfo create(Class<?> clazz) {
        return JavaTypeInfo.builder().setClass(clazz).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Class<?> getJavaType() {
        return this.clazz;
    }

    @Override
    public String toString() {
        return this.getApexName();
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, JavaTypeInfo> {
        private JavaTypeInfoUtil util = JavaTypeInfoUtil.get();
        private Class<?> clazz;

        private Builder() {
        }

        public Builder setClass(Class<?> clazz) {
            this.clazz = clazz;
            return this;
        }

        public Builder setUtil(JavaTypeInfoUtil util) {
            this.util = util;
            return this;
        }

        @Override
        public JavaTypeInfo build() {
            assert (this.clazz != null && !Objects.equals(Void.TYPE, this.clazz));
            String bytecodeName = MAPPED_TYPES.contains(this.clazz.getName()) ? TypeNameFactory.toBytecodeName(this.clazz) : "com/salesforce/api/interop/" + TypeNameFactory.toBytecodeName(this.clazz);
            this.setApexName("java:" + this.clazz.getName());
            this.setBytecodeName(bytecodeName);
            this.setNamespace(Namespaces.EMPTY);
            this.setUnitType(this.createUnitType());
            this.setModifiers(this.util.createModifiers(this.clazz.getModifiers()));
            this.setFields(FieldTable.EMPTY);
            this.setParents(this.util.createJava(this.clazz.getSuperclass()), this.util.createJava(this.clazz.getInterfaces()));
            this.setEnclosingType(this.util.createJava(this.clazz.getEnclosingClass()));
            this.setBasicType(BasicType.JAVA);
            this.setMethods(Initializers.memoize(new JavaTypeMethodTableInitializer(this.clazz, this.util)));
            return new JavaTypeInfo(this);
        }

        private UnitType createUnitType() {
            if (this.clazz.isAnnotation()) {
                return UnitType.ANNOTATION;
            }
            if (this.clazz.isInterface()) {
                return UnitType.INTERFACE;
            }
            if (this.clazz.isEnum()) {
                return UnitType.ENUM;
            }
            return UnitType.CLASS;
        }
    }
}

