/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.rules;

import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.resolver.rules.OnePartTypeNameResolveRules;
import apex.jorje.semantic.symbol.resolver.rules.TwoPartTypeNameResolveRule;
import apex.jorje.semantic.symbol.resolver.rules.TypeNameResolveUtil;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.VersionedTypeInfos;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.services.Version;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;

final class TwoPartTypeNameResolveRules {
    private TwoPartTypeNameResolveRules() {
    }

    static class PreCompilerReleaseInnerTypeOfAncestor
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new PreCompilerReleaseInnerTypeOfAncestor();

        PreCompilerReleaseInnerTypeOfAncestor() {
        }

        @Override
        public Version getMaxVersion() {
            return Version.COMPILER_RELEASE;
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            TypeInfo typeToIgnore = OnePartTypeNameResolveRules.TopLevelTypeInSameNamespace.INSTANCE.lookup(symbols, referencingType, firstPart);
            if (typeToIgnore == null) {
                return null;
            }
            if (!referencingType.parents().areSuperTypesResolved()) {
                return null;
            }
            return OnePartTypeNameResolveRules.InnerTypeOfParentType.INSTANCE.lookup(symbols, referencingType.parents().superType(), secondPart);
        }
    }

    static class ApexPagesMappedTypes
    implements TwoPartTypeNameResolveRule {
        static final ApexPagesMappedTypes INSTANCE = new ApexPagesMappedTypes();

        private ApexPagesMappedTypes() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            if (Objects.equals(TypeNameResolveUtil.APEX_PAGES, firstPart)) {
                return TypeNameResolveUtil.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SYSTEM, secondPart);
            }
            return null;
        }
    }

    static class TwoPartSystemExceptions
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new TwoPartSystemExceptions();

        private TwoPartSystemExceptions() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            if (Objects.equals(TypeNameResolveUtil.SYSTEM, firstPart)) {
                if (Objects.equals("exception", secondPart)) {
                    return VersionedTypeInfos.getException(referencingType.getCodeUnitDetails().getVersion());
                }
                if (TypeNameUtil.isException(secondPart)) {
                    return TypeNameResolveUtil.lookupInBuiltInException(symbols, referencingType, Namespaces.SYSTEM, secondPart);
                }
            }
            return null;
        }
    }

    static class BuiltInNamespace
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new BuiltInNamespace();

        private BuiltInNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            String candidateName = TypeNameResolveUtil.createTypeWithThreeParts("com/salesforce/api", firstPart, secondPart);
            TypeInfo type = symbols.find(referencingType, candidateName);
            if (type != null) {
                return type;
            }
            if (Objects.equals(TypeNameResolveUtil.SYSTEM, firstPart)) {
                return symbols.find(referencingType, "com/salesforce/api/" + secondPart);
            }
            return null;
        }
    }

    static class NamespaceAndTopLevelType
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new NamespaceAndTopLevelType();

        private NamespaceAndTopLevelType() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            String candidateName = TypeNameResolveUtil.createTypeWithNamespace(Namespaces.parse(firstPart), secondPart);
            return symbols.find(referencingType, candidateName);
        }
    }

    static class InnerClassInSystemNamespace
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new InnerClassInSystemNamespace();

        private InnerClassInSystemNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            String candidateName = TypeNameResolveUtil.createInnerTypeWithNamespace(Namespaces.SYSTEM, firstPart, secondPart);
            return symbols.find(referencingType, candidateName);
        }
    }

    static class TwoPartInnerTypeViaSubType
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new TwoPartInnerTypeViaSubType();

        private TwoPartInnerTypeViaSubType() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            if (!referencingType.parents().isResolved()) {
                return null;
            }
            TypeInfo subType = OnePartTypeNameResolveRules.TopLevelTypeInSameNamespace.INSTANCE.lookup(symbols, referencingType, firstPart);
            if (subType == null) {
                return null;
            }
            return TypeNameResolveUtil.InnerTypeViaSubTypeUtil.lookup(symbols, referencingType, subType, secondPart);
        }
    }

    static class InnerTypeInSameNamespace
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new InnerTypeInSameNamespace();

        private InnerTypeInSameNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            Namespace namespace = referencingType.getNamespace();
            String candidateName = TypeNameResolveUtil.createInnerTypeWithNamespace(namespace, firstPart, secondPart);
            return symbols.find(referencingType, candidateName);
        }
    }

    static class VfComponentTypeTwo
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new VfComponentTypeTwo();

        private VfComponentTypeTwo() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            Namespace outerNamespace = Namespaces.parse(firstPart);
            if (TypeNameResolveUtil.hasVfComponentTypes(symbols, referencingType) && Objects.equals(Namespaces.VF_COMPONENT, outerNamespace)) {
                Namespace innerNamespace = referencingType.getNamespace();
                return symbols.getSymbolProvider().getVfComponentType(symbols, referencingType, innerNamespace, secondPart);
            }
            return null;
        }
    }

    static class SystemNamedScalar
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new SystemNamedScalar();
        private static final Set<BasicType> LEGAL_TYPES = Sets.immutableEnumSet((Enum)TypeInfos.BLOB.getBasicType(), (Enum[])new BasicType[]{TypeInfos.BOOLEAN.getBasicType(), TypeInfos.CURRENCY.getBasicType(), TypeInfos.DATE.getBasicType(), TypeInfos.DATE_TIME.getBasicType(), TypeInfos.DECIMAL.getBasicType(), TypeInfos.DOUBLE.getBasicType(), TypeInfos.ID.getBasicType(), TypeInfos.INTEGER.getBasicType(), TypeInfos.LONG.getBasicType(), TypeInfos.STRING.getBasicType(), TypeInfos.TIME.getBasicType()});

        private SystemNamedScalar() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            if (!Objects.equals(TypeNameResolveUtil.SYSTEM, firstPart)) {
                return null;
            }
            TypeInfo type = TypeInfoTables.TYPES_BY_APEX_NAME.get(secondPart);
            if (type == null || !LEGAL_TYPES.contains((Object)type.getBasicType())) {
                return null;
            }
            Version version = referencingType.getCodeUnitDetails().getVersion();
            return version.isGreaterThanOrEqual(type.getBasicType().getMinVersion()) ? type : null;
        }
    }

    static class TwoPartSystemNamespace
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new TwoPartSystemNamespace();

        private TwoPartSystemNamespace() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            Version version = referencingType.getCodeUnitDetails().getVersion();
            if (version.isLessThan(Version.V156) || TypeNameResolveUtil.SYSTEM.equals(firstPart)) {
                TypeInfo type = symbols.find(referencingType, "com/salesforce/api/" + secondPart);
                if (type != null) {
                    return type;
                }
                type = TypeNameResolveUtil.lookupInBuiltInNamespace(symbols, referencingType, Namespaces.SYSTEM, secondPart);
                if (type != null) {
                    return type;
                }
                return symbols.find(referencingType, TypeNameResolveUtil.createTypeWithNamespace(Namespaces.SYSTEM, secondPart));
            }
            return null;
        }
    }

    static class Pre154SystemSObject
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new Pre154SystemSObject();

        Pre154SystemSObject() {
        }

        @Override
        public Version getMaxVersion() {
            return Version.V152;
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            if (Objects.equals(TypeNameResolveUtil.SYSTEM, firstPart)) {
                return symbols.getSymbolProvider().getSObjectType(referencingType, secondPart);
            }
            return null;
        }
    }

    static class SchemaSObject
    implements TwoPartTypeNameResolveRule {
        static final TwoPartTypeNameResolveRule INSTANCE = new SchemaSObject();

        private SchemaSObject() {
        }

        @Override
        public TypeInfo lookup(StandardSymbolResolver symbols, TypeInfo referencingType, String firstPart, String secondPart) {
            if (Objects.equals(TypeNameResolveUtil.SCHEMA, firstPart)) {
                return symbols.getSymbolProvider().getSObjectType(referencingType, secondPart);
            }
            return null;
        }
    }
}

