/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.resolver.interceptors;

import apex.common.collect.MoreIterables;
import apex.jorje.data.Identifier;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.symbol.resolver.interceptors.LegacyEarlyBindInterceptor;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public final class LegacyEarlyBindInterceptors {
    private LegacyEarlyBindInterceptors() {
    }

    public static class SObjectEarlyBindInterceptor
    implements LegacyEarlyBindInterceptor {
        private static final SObjectEarlyBindInterceptor INSTANCE = new SObjectEarlyBindInterceptor();
        private static final Set<String> ALLOW_SUBSEQUENT_BIND_TERMS = ImmutableSet.of("rowcause", "quickaction");

        private SObjectEarlyBindInterceptor() {
        }

        public static SObjectEarlyBindInterceptor get() {
            return INSTANCE;
        }

        @Override
        public boolean applies(ReferenceType callerReferenceType, List<Identifier> remainingTerms, TypeInfo type) {
            return this.hasRemainingTermsToIgnore(callerReferenceType, remainingTerms) && type.getBasicType() == BasicType.SOBJECT && !ALLOW_SUBSEQUENT_BIND_TERMS.contains(MoreIterables.getFirst(remainingTerms).getValue().toLowerCase());
        }

        private boolean hasRemainingTermsToIgnore(ReferenceType callerReferenceType, List<Identifier> remainingTerms) {
            return callerReferenceType == ReferenceType.LOAD && !remainingTerms.isEmpty() || callerReferenceType == ReferenceType.METHOD && remainingTerms.size() > 1;
        }
    }
}

