/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.common.base.ObjectHash;
import apex.jorje.semantic.compiler.StructuredVersion;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Objects;

public class StructuredVersionRange {
    private static final Interner<StructuredVersionRange> INTERNER = Interners.newWeakInterner();
    private final StructuredVersion minVersion;
    private final StructuredVersion maxVersion;

    private StructuredVersionRange(StructuredVersion minVersion, StructuredVersion maxVersion) {
        this.minVersion = Objects.requireNonNull(minVersion);
        this.maxVersion = Objects.requireNonNull(maxVersion);
    }

    public static StructuredVersionRange create(StructuredVersion minVersion, StructuredVersion maxVersion) {
        StructuredVersionRange newStructuredVersionRange = new StructuredVersionRange(minVersion, maxVersion);
        return INTERNER.intern(newStructuredVersionRange);
    }

    public int hashCode() {
        return ObjectHash.hash(this.minVersion, this.maxVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredVersionRange other = (StructuredVersionRange)obj;
        return Objects.equals(other.minVersion, this.minVersion) && Objects.equals(other.maxVersion, this.maxVersion);
    }

    public String toString() {
        return "(" + this.minVersion + ", " + this.maxVersion + ")";
    }

    public boolean within(StructuredVersion version) {
        return version.compareTo(this.minVersion) >= 0 && version.compareTo(this.maxVersion) <= 0;
    }
}

