/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilerStage;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.openjdk.jol.info.GraphLayout;

@Aspect
public class CompilerStageMemoryLoggerAspect {
    private static final Logger LOGGER = Logger.getLogger(CompilerStageMemoryLoggerAspect.class.getName());
    private String stageName;
    private CodeUnit codeUnit;

    @Pointcut(value="execution(* apex.jorje.semantic.compiler.CompilerStage.getOperation())")
    public void getOperation() {
    }

    @AfterReturning(pointcut="getOperation()")
    public void getStageName(JoinPoint joinPoint) {
        CompilerStage stage = (CompilerStage)((Object)joinPoint.getTarget());
        this.stageName = stage.name();
    }

    @Pointcut(value="@annotation(MemoryProfiled)")
    public void annotationPointCutDefinition() {
    }

    @Pointcut(value="execution(* *(..))")
    private void atExecution() {
    }

    @Around(value="@annotation(MemoryProfiled) && execution(* *(..))")
    public Object aroundAdvice(ProceedingJoinPoint joinPoint) {
        Object returnObject;
        Stopwatch timer = Stopwatch.createUnstarted();
        try {
            LOGGER.info("stage executed: " + this.stageName);
            timer.start();
            this.codeUnit = (CodeUnit)joinPoint.getArgs()[1];
            returnObject = joinPoint.proceed();
        }
        catch (Throwable exception) {
            throw new RuntimeException(exception);
        }
        finally {
            timer.stop();
            LOGGER.info("Stage " + this.stageName + " took " + timer.elapsed(TimeUnit.MILLISECONDS) + " ms");
        }
        return returnObject;
    }

    @After(value="annotationPointCutDefinition() && atExecution()")
    public void printNewLine() {
        LOGGER.info("for the stage " + this.stageName + " the memory usage for the codeUnit is \n\r");
        LOGGER.info(GraphLayout.parseInstance((Object)this.codeUnit).toFootprint() + "\n");
    }
}

