/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.compiler;

import apex.jorje.parser.impl.HiddenToken;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.common.IdeCalled;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.ValidationSettings;
import apex.jorje.semantic.compiler.parser.ParserEngine;
import apex.jorje.semantic.compiler.parser.ParserOutput;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.exception.CompilationException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ExecutionError;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CodeUnit {
    private static final Logger LOGGER = Logger.getLogger(CodeUnit.class.getName());
    private final ParserEngine parser;
    private final Errors errors;
    private final Logger logger;
    private final AstNodes nodeFactory;
    private final SourceFile source;
    private Compilation node;
    private List<ExternalDependency> references;
    private Set<TypeInfo> referencesForErrorPropagation;
    private CompilationOutput compilationOutput;
    private TypeInfo typeInfo;
    private NavigableMap<Integer, HiddenToken> hiddenTokenMap;

    @SfdcCalled
    protected CodeUnit(ParserEngine parser, SourceFile source) {
        this(source, parser, Errors.createErrors(), AstNodes.get(), LOGGER);
    }

    @VisibleForTesting
    CodeUnit(SourceFile source, ParserEngine parser, Errors errors, AstNodes nodeFactory, Logger logger) {
        this.source = source;
        this.errors = errors;
        this.parser = parser;
        this.nodeFactory = nodeFactory;
        this.logger = logger;
    }

    @SfdcCalled
    public SourceFile getSourceFile() {
        return this.source;
    }

    @SfdcCalled
    public CompilationOutput getOutput() {
        if (this.node == null) {
            return this.compilationOutput;
        }
        return this.node.getOutput();
    }

    @SfdcCalled
    public Optional<CompilationOutput> getOutput(String bytecodeName) {
        CompilationOutput innerOutput = this.getOutput().getInnerOutputs().get(bytecodeName);
        if (innerOutput != null) {
            return Optional.of(innerOutput);
        }
        if (this.getType().getBytecodeName().equalsIgnoreCase(bytecodeName)) {
            return Optional.of(this.getOutput());
        }
        return Optional.empty();
    }

    public TypeInfo getType() {
        if (this.node == null) {
            return this.typeInfo;
        }
        return this.node.getDefiningType();
    }

    void parse(ParserEngine.HiddenTokenBehavior hiddenTokensBehavior) {
        block7: {
            try {
                ParserOutput output = this.parser.parse(this.source, hiddenTokensBehavior);
                this.errors.addAll(output.getParseErrors());
                this.hiddenTokenMap = output.getHiddenTokenMap();
                this.node = this.nodeFactory.create(this.errors, this.source, null, output.getUnit());
            }
            catch (CompilationException x) {
                this.handleCompilationException(x);
            }
            catch (ExecutionError x) {
                if (x.getCause() instanceof StackOverflowError) {
                    this.errors.markInvalid(I18nSupport.getLabel("expression.too.long"));
                }
                throw x;
            }
            catch (StackOverflowError x) {
                this.errors.markInvalid(I18nSupport.getLabel("expression.too.long"));
            }
            catch (Exception x) {
                this.logger.log(Level.INFO, "unexpected error during apex parsing:\n" + this.getSourceFile().getBody(), x);
                if (!this.errors.isEmpty()) break block7;
                throw x;
            }
        }
        if (this.node == null) {
            this.node = Compilation.INVALID;
        }
    }

    <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        block4: {
            try {
                this.node.traverse(visitor, scope);
            }
            catch (CompilationException x) {
                this.handleCompilationException(x);
            }
            catch (StackOverflowError x) {
                this.errors.markInvalid(I18nSupport.getLabel("expression.too.long"));
            }
            catch (Exception x) {
                this.logger.log(Level.INFO, "unexpected error during apex " + visitor.getClass().getSimpleName() + ":\n" + this.getSourceFile().getBody(), x);
                if (!this.errors.isEmpty()) break block4;
                throw x;
            }
        }
    }

    void validate(SymbolResolver symbols, ValidationSettings settings) {
        block4: {
            try {
                this.node.validate(symbols, new ValidationScope(symbols, this.errors, settings));
            }
            catch (CompilationException x) {
                this.handleCompilationException(x);
            }
            catch (StackOverflowError x) {
                this.errors.markInvalid(I18nSupport.getLabel("expression.too.long"));
            }
            catch (Exception x) {
                if (!this.errors.isEmpty()) break block4;
                throw x;
            }
        }
    }

    void emit(Emitter emitter) {
        block6: {
            if (this.errors.isEmpty()) {
                try {
                    this.node.emit(emitter);
                    this.compilationOutput = this.node.getOutput();
                }
                catch (CompilationException x) {
                    emitter.clear();
                    this.handleCompilationException(x);
                }
                catch (StackOverflowError x) {
                    this.errors.markInvalid(I18nSupport.getLabel("expression.too.long"));
                }
                catch (Exception x) {
                    emitter.clear();
                    this.logger.log(Level.INFO, "unexpected error during apex emit:\n" + this.getSourceFile().getBody(), x);
                    if (!this.errors.isEmpty()) break block6;
                    throw x;
                }
            }
        }
        if (this.node != null) {
            this.typeInfo = this.node.getDefiningType();
            this.node = null;
        }
    }

    public void additionalValidate(AstVisitor<AdditionalPassScope> visitor) {
        block4: {
            try {
                this.node.traverse(visitor, new AdditionalPassScope(this.errors));
            }
            catch (CompilationException x) {
                this.handleCompilationException(x);
            }
            catch (StackOverflowError x) {
                this.errors.markInvalid(I18nSupport.getLabel("expression.too.long"));
            }
            catch (Exception x) {
                this.logger.log(Level.INFO, "unexpected error during apex additional validate:\n" + this.getSourceFile().getBody(), x);
                if (!this.errors.isEmpty()) break block4;
                throw x;
            }
        }
    }

    private void handleCompilationException(CompilationException x) {
        if (!this.errors.isInvalid(this.node)) {
            this.errors.markInvalid(this.node);
        }
        if (this.errors.isEmpty()) {
            this.errors.markInvalid(x);
        }
    }

    public Errors getErrors() {
        return this.errors;
    }

    public String toString() {
        return Objects.toString(this.source);
    }

    @SfdcCalled
    public List<ExternalDependency> getReferences() {
        Preconditions.checkNotNull(this.references, "Code unit references not yet resolved or already cleared!");
        return this.references;
    }

    public void setReferences(List<ExternalDependency> references) {
        Preconditions.checkNotNull(references);
        this.references = references;
    }

    @SfdcCalled
    public void clearReferences() {
        this.references = null;
    }

    @SfdcCalled
    @IdeCalled
    public Compilation getNode() {
        return this.node;
    }

    @SfdcCalled
    public String getName() {
        TypeInfo type = this.getType();
        return type != null && type.isResolved() ? type.getCodeUnitDetails().getName() : this.source.getKnownName();
    }

    @SfdcCalled
    public Namespace getNamespace() {
        return this.source.getNamespace();
    }

    @SfdcCalled
    public Set<TypeInfo> getReferencesForErrorPropagation() {
        return this.referencesForErrorPropagation;
    }

    void setReferencesForErrorPropagation(Set<TypeInfo> referencesForErrorPropagation) {
        this.referencesForErrorPropagation = referencesForErrorPropagation;
    }

    @IdeCalled
    public NavigableMap<Integer, HiddenToken> getHiddenTokenMap() {
        return this.hiddenTokenMap;
    }
}

