/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common;

import apex.common.base.ObjectHash;
import apex.common.collect.MoreIterables;
import apex.jorje.semantic.common.TestSObjectTypeInfos;
import apex.jorje.semantic.common.TestSymbolProvider;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class TestAccessEvaluator
implements AccessEvaluator {
    private final SetMultimap<Namespace, StructuredVersion> validPageVersions = HashMultimap.create();
    private final SetMultimap<SObjectTypeInfo, TypeInfo> visibleSetupEntitiesToTypes = HashMultimap.create();
    private final Set<Namespace> accessibleSystemNamespaces;
    private final Set<Namespace> notAccessibleOrTrustedNamespace;
    private final Set<PlaceholderOrgPerm> orgPerm;
    private final Set<AllowedPermGuard> allowedPermGuards;
    private final Set<Namespace> reservedNamespaces;
    private final Set<String> globalComponents;
    private final Set<Namespace> managedPackagesNotInstalled = new HashSet<Namespace>();
    private final Set<String> typesWithConnectApiDeserializers;
    private final Set<TypeInfo> typesWithRemoteAction;
    private boolean hasInternalSfdc;
    private boolean isRunningTests;
    private boolean hasPrivateApi;
    private boolean isTrustedApplication;
    private boolean hasLocalizedTranslation;
    private boolean isSfdc;
    private boolean isReallyRunningTests;
    private boolean hasApexGenericTypes;
    private boolean hasRemoteActionPerm = true;
    private boolean useTestValueForAnonymousScriptLengthLimit;
    private boolean allowIdentifiersInSwitch;
    private final Set<Namespace> secondGenerationPackagingNamespaces;

    public TestAccessEvaluator() {
        this.accessibleSystemNamespaces = new HashSet<Namespace>();
        this.notAccessibleOrTrustedNamespace = new HashSet<Namespace>();
        this.orgPerm = new HashSet<PlaceholderOrgPerm>();
        this.allowedPermGuards = new HashSet<AllowedPermGuard>();
        this.reservedNamespaces = new HashSet<Namespace>();
        this.globalComponents = new HashSet<String>();
        this.typesWithConnectApiDeserializers = new HashSet<String>();
        this.typesWithRemoteAction = new HashSet<TypeInfo>();
        this.secondGenerationPackagingNamespaces = new HashSet<Namespace>();
    }

    @Override
    public boolean hasPermission(PlaceholderOrgPerm orgPerm) {
        return this.orgPerm.contains((Object)orgPerm);
    }

    @Override
    public boolean hasPermissionForPermGuard(Namespace referencingNamespace, String orgPerm) {
        return this.allowedPermGuards.contains(new AllowedPermGuard(referencingNamespace, orgPerm));
    }

    @Override
    public boolean hasPrivateApi() {
        return this.hasPrivateApi;
    }

    @Override
    public boolean hasLocalizedTranslation() {
        return this.hasLocalizedTranslation;
    }

    @Override
    public boolean hasInternalSfdc() {
        return this.hasInternalSfdc;
    }

    @Override
    public boolean isTrustedApplication(TypeInfo referencingType) {
        return this.isTrustedApplication;
    }

    @Override
    public boolean isReservedNamespace(Namespace namespace) {
        return this.reservedNamespaces.contains(namespace);
    }

    @Override
    public boolean isReservedNamespace(Namespace namespace, boolean excludePackages) {
        return this.reservedNamespaces.contains(namespace);
    }

    @Override
    public boolean isAccessibleSystemNamespace(Namespace namespace) {
        return this.accessibleSystemNamespaces.contains(namespace);
    }

    @Override
    public boolean isAccessibleOrTrustedNamespace(Namespace namespace) {
        return !this.notAccessibleOrTrustedNamespace.contains(namespace);
    }

    @Override
    public boolean isRunningTests() {
        return this.isRunningTests;
    }

    @Override
    public boolean isReallyRunningTests() {
        return this.isReallyRunningTests;
    }

    @Override
    public boolean isSfdc() {
        return this.isSfdc;
    }

    @Override
    public boolean hasApexParameterizedTypes() {
        return this.hasApexGenericTypes;
    }

    @Override
    public boolean isValidPackageVersion(Namespace namespace, StructuredVersion version) {
        return this.validPageVersions.containsEntry(namespace, version);
    }

    @Override
    public boolean isManagedPackageInstalled(Namespace namespace) {
        return !this.managedPackagesNotInstalled.contains(namespace);
    }

    @Override
    public boolean isSetupEntityVisibleToType(SObjectTypeInfo type, TypeInfo referencingType) {
        TypeInfo visibleReferencingType = MoreIterables.getFirst(this.visibleSetupEntitiesToTypes.get((Object)type), null);
        return visibleReferencingType != null && Objects.equals(visibleReferencingType.getBytecodeName(), referencingType.getBytecodeName());
    }

    @Override
    public boolean hasConnectDeserializer(TypeInfo type) {
        return this.typesWithConnectApiDeserializers.contains(type.getApexName());
    }

    @Override
    public boolean hasRemoteAction(TypeInfo type) {
        return this.typesWithRemoteAction.contains(type);
    }

    @Override
    public boolean hasRemoteActionPerm() {
        return this.hasRemoteActionPerm;
    }

    @Override
    public boolean isGlobalComponent(TypeInfo type) {
        return this.globalComponents.contains(type.getApexName());
    }

    @Override
    public boolean hasPersonAccountApiAvailable() {
        return this.orgPerm.contains((Object)PlaceholderOrgPerm.PERSON_ACCOUNT_ENABLED);
    }

    @Override
    public boolean useTestValueForAnonymousScriptLengthLimit() {
        return this.useTestValueForAnonymousScriptLengthLimit;
    }

    @Override
    public boolean isSecondGenerationPackagingNamespace(Namespace namespace) {
        return this.secondGenerationPackagingNamespaces.contains(namespace);
    }

    public TestAccessEvaluator addManagedPackageNotInstalled(Namespace namespace) {
        this.managedPackagesNotInstalled.add(namespace);
        return this;
    }

    public TestAccessEvaluator addReservedNamespace(Namespace namespace) {
        this.reservedNamespaces.add(namespace);
        return this;
    }

    public TestAccessEvaluator addPermission(PlaceholderOrgPerm orgPerm) {
        this.orgPerm.add(orgPerm);
        return this;
    }

    public TestAccessEvaluator setHasInternalSfdc(boolean hasInternalSfdc) {
        this.hasInternalSfdc = hasInternalSfdc;
        return this;
    }

    public TestAccessEvaluator addValidPackageVersion(Namespace namespace, StructuredVersion version) {
        this.validPageVersions.put(namespace, version);
        return this;
    }

    public TestAccessEvaluator addSetupEntityVisibleToType(SObjectTypeInfo type, String typeName) {
        StandardTypeInfo typeInfo = (StandardTypeInfo)((StandardTypeInfoImpl.Builder)((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setApexName(typeName)).setBytecodeName(typeName)).buildResolved();
        this.visibleSetupEntitiesToTypes.put(type, typeInfo);
        return this;
    }

    public TestAccessEvaluator setIsRunningTests(boolean isRunningTests) {
        this.isRunningTests = isRunningTests;
        return this;
    }

    public TestAccessEvaluator setHasPrivateApi(boolean hasPrivateApi) {
        this.hasPrivateApi = hasPrivateApi;
        return this;
    }

    public TestAccessEvaluator setIsTrustedApplication(boolean isTrustedApplication) {
        this.isTrustedApplication = isTrustedApplication;
        return this;
    }

    public TestAccessEvaluator setHasLocalizedTranslation(boolean hasLocalizedTranslation) {
        this.hasLocalizedTranslation = hasLocalizedTranslation;
        return this;
    }

    public TestAccessEvaluator setIsSfdc(boolean isSfdc) {
        this.isSfdc = isSfdc;
        return this;
    }

    public TestAccessEvaluator setIsReallyRunningTests(boolean isReallyRunningTests) {
        this.isReallyRunningTests = isReallyRunningTests;
        return this;
    }

    public TestAccessEvaluator setAccessibleSystemNamespace(Namespace namespace) {
        this.accessibleSystemNamespaces.add(namespace);
        return this;
    }

    public TestAccessEvaluator setNotAccessibleOrTrustedNamespace(Namespace namespace) {
        this.notAccessibleOrTrustedNamespace.add(namespace);
        return this;
    }

    public TestAccessEvaluator setHasApexGenericType(boolean hasApexGenericTypes) {
        this.hasApexGenericTypes = hasApexGenericTypes;
        return this;
    }

    public TestAccessEvaluator allowPermGuard(Namespace namespace, String permGuard) {
        this.allowedPermGuards.add(new AllowedPermGuard(namespace, permGuard));
        return this;
    }

    public TestAccessEvaluator setHasRemoteActionPerm(boolean hasRemoteActionPerm) {
        this.hasRemoteActionPerm = hasRemoteActionPerm;
        return this;
    }

    public TestAccessEvaluator setTypeWithConnectApiDeserializer(String typeName) {
        this.typesWithConnectApiDeserializers.add(typeName);
        return this;
    }

    public TestAccessEvaluator setTypeWithRemoteAction(TypeInfo type) {
        this.typesWithRemoteAction.add(type);
        return this;
    }

    public TestAccessEvaluator useTestValueForAnonymousScriptLengthLimit(boolean useTestValue) {
        this.useTestValueForAnonymousScriptLengthLimit = useTestValue;
        return this;
    }

    public void setGlobalComponent(String globalComponent) {
        this.globalComponents.add(globalComponent);
    }

    public void enablePersonAccount(TestSymbolProvider symbols) {
        this.orgPerm.add(PlaceholderOrgPerm.PERSON_ACCOUNT_ENABLED);
        symbols.addAdditionalBuiltInSObjectTypes(TestSObjectTypeInfos.PERSON_ACCOUNT);
        symbols.addAdditionalBuiltInSObjectTypes(TestSObjectTypeInfos.BUSINESS_ACCOUNT);
    }

    public TestAccessEvaluator setPackaging2Namespace(Namespace namespace) {
        this.secondGenerationPackagingNamespaces.add(namespace);
        return this;
    }

    @Override
    public boolean allowIdentifiersInSwitch() {
        return this.allowIdentifiersInSwitch;
    }

    public TestAccessEvaluator allowIdentifiersInSwitch(boolean allowIdentifiersInSwitch) {
        this.allowIdentifiersInSwitch = allowIdentifiersInSwitch;
        return this;
    }

    private static class AllowedPermGuard {
        private final Namespace referencingNamespace;
        private final String permGuard;

        AllowedPermGuard(Namespace namespace, String permGuard) {
            this.referencingNamespace = namespace;
            this.permGuard = permGuard;
        }

        public int hashCode() {
            return ObjectHash.hash(this.referencingNamespace, this.permGuard);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AllowedPermGuard other = (AllowedPermGuard)obj;
            return Objects.equals(this.referencingNamespace, other.referencingNamespace) && Objects.equals(this.permGuard, other.permGuard);
        }
    }
}

