/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common;

import apex.jorje.semantic.common.I18nSupplier;
import apex.jorje.semantic.symbol.member.method.signature.SignatureUtil;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;
import java.util.List;
import java.util.Optional;

public class I18nSupplierWithMethodSignature
implements I18nSupplier {
    private final String messageKey;
    private final TypeInfo definingType;
    private final String methodName;
    private final TypeInfo returnType;
    private final List<TypeInfo> parameterTypes;
    private final Optional<Object> otherParam;

    private I18nSupplierWithMethodSignature(String messageKey, TypeInfo definingType, String methodName, TypeInfo returnType, List<TypeInfo> parameterTypes, Optional<Object> otherParam) {
        this.messageKey = messageKey;
        this.definingType = definingType;
        this.methodName = methodName;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.otherParam = otherParam;
    }

    public static I18nSupplierWithMethodSignature create(String messageKey, TypeInfo definingType, String methodName, TypeInfo returnType, List<TypeInfo> parameterTypes) {
        return new I18nSupplierWithMethodSignature(messageKey, definingType, methodName, returnType, parameterTypes, Optional.empty());
    }

    public static I18nSupplierWithMethodSignature create(String messageKey, TypeInfo definingType, String methodName, TypeInfo returnType, List<TypeInfo> parameterTypes, Object otherParam) {
        return new I18nSupplierWithMethodSignature(messageKey, definingType, methodName, returnType, parameterTypes, Optional.of(otherParam));
    }

    @Override
    public String get() {
        String signatureString = SignatureUtil.createStringRepresentation(this.definingType, this.methodName, this.returnType, this.parameterTypes);
        return this.otherParam.map(param -> I18nSupport.getLabel(this.messageKey, signatureString, param)).orElseGet(() -> I18nSupport.getLabel(this.messageKey, signatureString));
    }
}

