/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.data.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.PackageVersionExpression;
import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.reference.TypeReferences;
import apex.jorje.services.I18nSupport;
import java.util.List;
import java.util.Optional;

@SfdcCalled
public class PackageUploadVisitor
extends AstVisitor<AdditionalPassScope> {
    private static final String CUSTOM_METADATA_LOWER = Namespaces.CUSTOM_METADATA.getGlobal().toLowerCase();
    private final String namespaceNameLower;
    private final boolean doUnmanagedPackageChecks;

    @SfdcCalled
    public PackageUploadVisitor(Namespace namespace, boolean isManaged) {
        this.namespaceNameLower = namespace.getNameLower();
        this.doUnmanagedPackageChecks = !isManaged && !Namespace.isEmptyOrNull(namespace);
    }

    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(UserClass node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            Optional<TypeRef> parentTypeRef = node.getDefiningType().getCodeUnitDetails().getSuperTypeRef();
            parentTypeRef.ifPresent(typeRef -> this.checkName((AstNode)node, scope, (TypeRef)typeRef));
        }
    }

    @Override
    public void visitEnd(UserTrigger node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName((AstNode)node, scope, node.getTargetName());
        }
    }

    @Override
    public void visitEnd(ReferenceExpression node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            for (Identifier name : node.getNames()) {
                this.checkName((AstNode)node, scope, name);
            }
        }
    }

    @Override
    public void visitEnd(MethodCallExpression node, AdditionalPassScope scope) {
        MethodInfo method = node.getMethod().get();
        if (TypeInfoEquivalence.isEquivalent(method.getDefiningType(), InternalTypeInfos.SYSTEM_SCHEMA) && (method.getName().equalsIgnoreCase("describeDataCategoryGroups") || method.getName().equalsIgnoreCase("describeDataCategoryGroupStructures"))) {
            scope.getErrors().markInvalid((AstNode)node.getReferenceContext().getExpression(), I18nSupport.getLabel("export.data.category"));
        }
        if (this.doUnmanagedPackageChecks) {
            this.checkName((AstNode)node, scope, node.getReferenceContext());
            this.checkName((AstNode)node, scope, node.getNameUsed());
        }
    }

    @Override
    public void visitEnd(NewObjectExpression node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName((AstNode)node, scope, node.getTypeRef());
        }
    }

    @Override
    public void visitEnd(PackageVersionExpression node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("package.version.forbidden"));
        }
    }

    @Override
    public void visitEnd(VariableExpression node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName((AstNode)node, scope, node.getIdentifier());
        }
    }

    @Override
    public void visitEnd(FieldDeclaration node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName((AstNode)node, scope, node.getTypeNameUsed());
        }
    }

    @Override
    public void visitEnd(VariableDeclaration node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName((AstNode)node, scope, node.getTypeNameUsed());
        }
    }

    @Override
    public void visitEnd(Parameter node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName((AstNode)node, scope, node.getTypeRef());
        }
    }

    @Override
    public void visitEnd(Method node, AdditionalPassScope scope) {
        if (this.doUnmanagedPackageChecks) {
            this.checkName((AstNode)node, scope, node.getReturnTypeRef());
        }
    }

    private void checkName(AstNode node, AdditionalPassScope scope, TypeRef typeRef) {
        if (typeRef == TypeReferences.GENERATED_TYPE_REF) {
            return;
        }
        this.checkName(node, scope, typeRef.getNames());
        for (TypeRef typeArgument : typeRef.getTypeArguments()) {
            this.checkName(node, scope, typeArgument);
        }
    }

    private void checkName(AstNode node, AdditionalPassScope scope, ReferenceContext reference) {
        this.checkName(node, scope, reference.getNames());
    }

    private void checkName(AstNode node, AdditionalPassScope scope, List<Identifier> identifiers) {
        for (Identifier identifier : identifiers) {
            if (identifier.getValue().equalsIgnoreCase(this.namespaceNameLower)) {
                scope.getErrors().markInvalid(node, identifier.getLoc(), I18nSupport.getLabel("explicit.unmanaged"));
            }
            this.checkName(node, scope, identifier);
        }
    }

    private void checkName(AstNode node, AdditionalPassScope scope, Identifier identifier) {
        String name = identifier.getValue().toLowerCase();
        if (name.startsWith(CUSTOM_METADATA_LOWER)) {
            name = name.substring(Namespaces.CUSTOM_METADATA.getGlobal().length());
        }
        if (name.startsWith(this.namespaceNameLower + "__")) {
            scope.getErrors().markInvalid(node, identifier.getLoc(), I18nSupport.getLabel("explicit.unmanaged"));
        }
    }
}

