/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.BooleanOp;
import apex.jorje.data.ast.WhenBlock;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Comparison;
import apex.jorje.semantic.ast.expression.Comparisons;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.SwitchStatement;
import apex.jorje.semantic.ast.statement.WhenBlock;
import apex.jorje.semantic.ast.statement.WhenCase;
import apex.jorje.semantic.ast.statement.WhenCases;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import com.google.common.collect.MoreLists;
import java.util.List;
import org.objectweb.asm.Label;

public class ValueWhenBlock
implements WhenBlock {
    private final SwitchStatement switchStatement;
    private final List<WhenCase> whenCases;
    private final Statement statement;

    ValueWhenBlock(SwitchStatement switchStatement, WhenBlock.ValueWhen values) {
        this.switchStatement = switchStatement;
        this.whenCases = AstNodes.filterNotNull(values.whenCases).stream().map(whenCase -> WhenCases.create(switchStatement, whenCase)).collect(MoreLists.toImmutableList());
        this.statement = AstNodes.get().create((AstNode)switchStatement, values.stmnt);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (WhenCase whenCase : this.whenCases) {
                whenCase.traverse(visitor, scope);
            }
            this.statement.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        Errors errors = scope.getErrors();
        for (WhenCase whenCase : this.whenCases) {
            whenCase.validate(symbols, scope);
        }
        this.statement.validate(symbols, scope);
        if (errors.isInvalid(this.whenCases) || errors.isInvalid(this.statement)) {
            errors.markInvalid(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        Label trueLabel = new Label();
        TypeInfo switchType = this.switchStatement.getExpressionType();
        Label falseLabel = new Label();
        for (int index = 0; index < this.whenCases.size(); ++index) {
            Comparison comparison;
            if (index != 0) {
                emitter.emit(falseLabel);
                falseLabel = new Label();
            }
            WhenCase whenCase = this.whenCases.get(index);
            TypeInfo whenType = whenCase.getType();
            Location loc = whenCase.getLoc();
            TypeInfo commonType = Distance.get().getCommonType(this.getDefiningType(), switchType, whenType);
            Comparison comparison2 = comparison = commonType.getBasicType() == BasicType.STRING ? Comparisons.CASE_SENSITIVE_STRING_COMPARISON : Comparisons.get(commonType, BooleanOp.DOUBLE_EQUAL);
            if (TypeInfoEquivalence.isEquivalent(whenType, InternalTypeInfos.NULL)) {
                emitter.emitVar(loc, 25, this.switchStatement.getVarIndex());
                emitter.emitJump(loc, 199, falseLabel);
                continue;
            }
            emitter.emitVar(loc, 25, this.switchStatement.getVarIndex());
            emitter.emitJump(loc, 198, falseLabel);
            emitter.emitVar(loc, 25, this.switchStatement.getVarIndex());
            TypeConversion.emit(loc, emitter, switchType, commonType);
            comparison.emitUnbox(emitter, commonType);
            whenCase.emit(emitter);
            TypeConversion.emit(loc, emitter, whenType, commonType);
            comparison.emitUnbox(emitter, commonType);
            comparison.emitComparison(loc, emitter, falseLabel);
            emitter.emitJump(loc, 167, trueLabel);
        }
        emitter.emit(trueLabel);
        this.statement.emit(emitter);
        if (!this.statement.isReturnable()) {
            emitter.emitJump(this.switchStatement.getLoc(), 167, this.switchStatement.getExit());
        }
        emitter.emit(falseLabel);
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.switchStatement.getDefiningType();
    }

    @Override
    public Location getLoc() {
        return this.switchStatement.getLoc();
    }

    @Override
    public Statement getBlock() {
        return this.statement;
    }

    public List<WhenCase> getWhenCases() {
        return this.whenCases;
    }
}

