/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.I18nSupport;

public class BreakStatement
extends Statement {
    private final Location loc;

    public BreakStatement(AstNode definingNode, Stmnt.BreakStmnt stmnt) {
        super(definingNode);
        this.loc = stmnt.loc;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (!scope.isLooping()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.break"));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        assert (!emitter.getLoopStack().isEmpty());
        emitter.emitStatementExecuted(this.loc, true, false);
        emitter.getLoopStack().emitBreak(this.loc);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }
}

