/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.common.collect.MoreIterables;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRules;
import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.services.I18nSupport;

public class ReadOnlyContextRule
implements AnnotationContextRule {
    private static final ReadOnlyContextRule INSTANCE = new ReadOnlyContextRule();

    private ReadOnlyContextRule() {
    }

    public static ReadOnlyContextRule get() {
        return INSTANCE;
    }

    @Override
    public void validate(MethodContext context) {
        if (context.getModifiers().has(ModifierTypeInfos.STATIC)) {
            AnnotationRules.requiredAnyModifier(ModifierTypeInfos.WEB_SERVICE, AnnotationTypeInfos.REMOTE_ACTION).validate(context, context.getModifiers(), AnnotationTypeInfos.READ_ONLY.toString());
            return;
        }
        TypeInfo schedulable = context.getSymbols().lookupTypeInfo(context.getDefiningType(), InternalTypeInfos.SYSTEM_SCHEDULABLE);
        TypeInfo schedulableContext = context.getSymbols().lookupTypeInfo(context.getDefiningType(), InternalTypeInfos.SYSTEM_SCHEDULABLE_CONTEXT);
        if (!(context.getMethodInfo().getName().equalsIgnoreCase("execute") && context.getMethodInfo().getParameters().size() == 1 && Distance.get().canAssign(context.getDefiningType(), context.getDefiningType(), schedulable) && TypeInfoEquivalence.isEquivalent(MoreIterables.getOnlyElement(context.getMethodInfo().getParameterTypes()), schedulableContext))) {
            context.addNodeError(I18nSupport.getLabel("invalid.read.only"));
        }
    }

    @Override
    public void validate(FieldContext context) {
        throw new UnexpectedCodePathException();
    }

    @Override
    public void validate(TypeContext context) {
        throw new UnexpectedCodePathException();
    }
}

