/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContextRule;
import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;

public class FieldContext
extends AnnotationContext {
    private final FieldInfo field;
    private final Element element;

    private FieldContext(AstNode node, FieldInfo field, SymbolScope scope, Element element) {
        super(node, scope);
        this.field = field;
        this.element = element;
    }

    public static FieldContext createProperty(Property node, SymbolScope scope) {
        return new FieldContext(node, node.getFieldInfo(), scope, Element.PROPERTY);
    }

    public static FieldContext createField(Field node, SymbolScope scope) {
        return new FieldContext(node, node.getFieldInfo(), scope, Element.FIELD);
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.field.getDefiningType();
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.field.getModifiers();
    }

    @Override
    public void accept(AnnotationContextRule visitor) {
        visitor.validate(this);
    }

    public FieldInfo getFieldInfo() {
        return this.field;
    }
}

