/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.common.base.MoreStrings;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.services.I18nSupport;
import com.google.common.annotations.VisibleForTesting;

class VariableErrorMessageOverride {
    private VariableErrorMessageOverride() {
    }

    public static String get(SymbolResolver symbols, TypeInfo referencingType, TypeInfo referenceType, String name) {
        if (TypeInfoEquivalence.isEquivalent(referenceType, symbols.getPageTypeInfo())) {
            Namespace callerNamespace = referencingType.getNamespace();
            String namespacedName = VariableErrorMessageOverride.beginsWithNamespaceAndSeparator(name, callerNamespace) ? name : callerNamespace + "__" + name;
            return I18nSupport.getLabel("page.does.not.exist", namespacedName);
        }
        return I18nSupport.getLabel("variable.does.not.exist", name);
    }

    @VisibleForTesting
    static boolean beginsWithNamespaceAndSeparator(String name, Namespace namespace) {
        return Namespace.isEmptyOrNull(namespace) || MoreStrings.startsWithIgnoreCase(name, namespace.getGlobal()) && name.regionMatches(namespace.getGlobal().length(), "__", 0, 2);
    }
}

