/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.condition.Condition;
import apex.jorje.semantic.ast.condition.StandardCondition;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.services.I18nSupport;
import org.objectweb.asm.Label;

public class TernaryExpression
extends Expression {
    private final Location loc;
    private final Condition condition;
    private final Expression trueExpression;
    private final Expression falseExpression;

    public TernaryExpression(AstNode definingNode, Expr.TernaryExpr expr) {
        super(definingNode);
        this.loc = Locations.from(expr);
        this.condition = new StandardCondition(this, expr.condition);
        this.trueExpression = AstNodes.get().create((AstNode)this, expr.trueExpr);
        this.falseExpression = AstNodes.get().create((AstNode)this, expr.falseExpr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
            this.trueExpression.traverse(visitor, scope);
            this.falseExpression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.condition.validate(symbols, scope);
        this.trueExpression.validate(symbols, scope);
        this.falseExpression.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.condition, this.trueExpression, this.falseExpression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        TypeInfo commonType = this.getTernaryType(this.trueExpression.getType(), this.falseExpression.getType());
        if (commonType == null) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("incompatible.ternary.expression.types", this.falseExpression.getType(), this.trueExpression.getType()));
        } else {
            this.setType(commonType);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        Label exit = new Label();
        Label falseLabel = this.condition.getFalseLabel(emitter);
        this.trueExpression.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.trueExpression.getType(), this.getType());
        emitter.emitJump(this.loc, 167, exit);
        emitter.emit(falseLabel);
        this.falseExpression.emit(emitter);
        TypeConversion.emit(this.loc, emitter, this.falseExpression.getType(), this.getType());
        emitter.emit(exit);
    }

    private TypeInfo getTernaryType(TypeInfo trueExpressionType, TypeInfo falseExpressionType) {
        if (TypeInfoEquivalence.isEquivalent(trueExpressionType, falseExpressionType)) {
            return trueExpressionType;
        }
        if (Distance.get().canAssign(this.getDefiningType(), falseExpressionType, trueExpressionType)) {
            return trueExpressionType;
        }
        if (Distance.get().canAssign(this.getDefiningType(), trueExpressionType, falseExpressionType)) {
            return falseExpressionType;
        }
        return null;
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }
}

