/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.ast.AssignmentOp;
import apex.jorje.semantic.ast.expression.AssignmentExpression;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.PostfixExpression;
import apex.jorje.semantic.ast.expression.PrefixExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.services.Version;

public class SpecialAssignmentCalculator {
    private static final SpecialAssignmentCalculator INSTANCE = new SpecialAssignmentCalculator();
    private static final AstVisitor<SpecialAssignmentScope> IS_BINARY_LOAD = new AstVisitor<SpecialAssignmentScope>(){

        @Override
        public void visitEnd(BinaryExpression node, SpecialAssignmentScope scope) {
            scope.value = scope.expression == node.getLeft();
        }
    };
    private static final AstVisitor<SpecialAssignmentScope> IS_SPECIAL_ASSIGNMENT = new AstVisitor<SpecialAssignmentScope>(){

        @Override
        public void visitEnd(AssignmentExpression node, SpecialAssignmentScope scope) {
            if (node.getOp() != AssignmentOp.EQUALS) {
                node.getRight().traverse(IS_BINARY_LOAD, scope);
                scope.value = (byte)(scope.value | (scope.expression == node.getLeft() ? 1 : 0));
            }
        }

        @Override
        public void visitEnd(PrefixExpression node, SpecialAssignmentScope scope) {
            scope.value = node.getOp().isIncOrDec() && Version.V192.isLessThanOrEqual(VersionUtil.get(node));
        }

        @Override
        public void visitEnd(PostfixExpression node, SpecialAssignmentScope scope) {
            scope.value = Version.V192.isLessThanOrEqual(VersionUtil.get(node));
        }
    };

    private SpecialAssignmentCalculator() {
    }

    public static SpecialAssignmentCalculator get() {
        return INSTANCE;
    }

    public boolean calculate(Expression expression) {
        SpecialAssignmentScope scope = new SpecialAssignmentScope(expression);
        expression.getDefiningNode().traverse(IS_SPECIAL_ASSIGNMENT, scope);
        return scope.value;
    }

    private static class SpecialAssignmentScope
    extends Scope {
        private final Expression expression;
        private boolean value;

        private SpecialAssignmentScope(Expression expression) {
            this.expression = expression;
            this.value = false;
        }
    }
}

