/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.services.I18nSupport;

public class MapEntryNode
implements AstNode {
    private final TypeInfo definingType;
    private final Expression key;
    private final Expression value;
    private final NewMapLiteralExpression map;

    MapEntryNode(NewMapLiteralExpression map, Expression key, Expression value) {
        this.definingType = map.getDefiningType();
        this.map = map;
        this.key = key;
        this.value = value;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.key.traverse(visitor, scope);
            this.value.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.key.validate(symbols, scope);
        this.value.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.key, this.value)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        if (!Distance.get().canAssign(this.getDefiningType(), this.key.getType(), this.map.getKeyType())) {
            scope.getErrors().markInvalid((AstNode)this.key, I18nSupport.getLabel("invalid.initial.key.type", this.key.getType(), this.map.getKeyType()));
        }
        if (!Distance.get().canAssign(this.getDefiningType(), this.value.getType(), this.map.getValueType())) {
            scope.getErrors().markInvalid((AstNode)this.value, I18nSupport.getLabel("invalid.initial.value.type", this.value.getType(), this.map.getValueType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emit(this.map.getLoc(), 89);
        this.key.emit(emitter);
        TypeConversion.emit(this.map.getLoc(), emitter, this.key.getType(), this.map.getKeyType());
        this.value.emit(emitter);
        TypeConversion.emit(this.map.getLoc(), emitter, this.value.getType(), this.map.getValueType());
        emitter.emit(this.map.getLoc(), this.map.getPutMethod());
        emitter.emit(this.map.getLoc(), 87);
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Location getLoc() {
        return this.map.getLoc();
    }
}

