/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.context.AnnotationVisitor;
import apex.jorje.semantic.ast.context.LoopStack;
import apex.jorje.semantic.ast.context.MethodStack;
import apex.jorje.semantic.ast.context.ProxyMethodTable;
import apex.jorje.semantic.ast.context.TryCatchFinallyStack;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.BooleanEmitMethods;
import apex.jorje.semantic.bcl.DoubleEmitMethods;
import apex.jorje.semantic.bcl.IntegerEmitMethods;
import apex.jorje.semantic.bcl.LongEmitMethods;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import apex.jorje.services.Version;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Deque;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;

public class Emitter {
    private static final Handle BOOTSTRAP_METHOD = new Handle(6, InternalTypeInfos.SYSTEM.getBytecodeName(), "bootstrap", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
    private final AccessEvaluator accessEvaluator;
    private final TryCatchFinallyStack tryCatchFinallyStack;
    private final LoopStack loopStack;
    private final TypeStack typeStack;
    private final MethodStack methodStack;
    private final AnnotationVisitor annotationVisitor;
    private final ProxyMethodTable proxyMethodTable;
    private final ArrayDeque<VariableVisitor<?, VariableVisitor.Context>> variableVisitors;
    private FieldInfo emitRawProperty;
    private boolean suppressLocation;
    private CodeUnit codeUnit;

    public Emitter(AccessEvaluator accessEvaluator) {
        this.accessEvaluator = accessEvaluator;
        this.tryCatchFinallyStack = new TryCatchFinallyStack(this);
        this.loopStack = new LoopStack(this);
        this.typeStack = new TypeStack();
        this.methodStack = new MethodStack();
        this.annotationVisitor = new AnnotationVisitor();
        this.proxyMethodTable = new ProxyMethodTable(this);
        this.variableVisitors = Queues.newArrayDeque();
        this.emitRawProperty = null;
        this.suppressLocation = false;
    }

    public TryCatchFinallyStack getTryCatchFinallyStack() {
        return this.tryCatchFinallyStack;
    }

    public LoopStack getLoopStack() {
        return this.loopStack;
    }

    public TypeStack getTypeStack() {
        return this.typeStack;
    }

    public MethodStack getMethodStack() {
        return this.methodStack;
    }

    public AnnotationVisitor getAnnotationVisitor() {
        return this.annotationVisitor;
    }

    public Deque<VariableVisitor<?, VariableVisitor.Context>> getVariableVisitors() {
        return this.variableVisitors;
    }

    public void assertEmpty() {
        assert (this.tryCatchFinallyStack.isEmpty()) : "try catch finally stack is NOT empty";
        assert (this.loopStack.isEmpty()) : "loop stack is NOT empty";
        assert (this.typeStack.isEmpty()) : "type stack is NOT empty";
        assert (this.methodStack.isEmpty()) : "method stack is NOT empty";
        assert (this.variableVisitors.isEmpty()) : "variable visitors stack is NOT empty";
        assert (this.codeUnit == null) : "code unit was NOT nulled";
    }

    public void clear() {
        this.tryCatchFinallyStack.clear();
        this.loopStack.clear();
        this.typeStack.clear();
        this.methodStack.clear();
        this.variableVisitors.clear();
    }

    public CodeUnit getCodeUnit() {
        return this.codeUnit;
    }

    public void setCodeUnit(CodeUnit codeUnit) {
        this.codeUnit = codeUnit;
    }

    public boolean getSuppressLocation() {
        return this.suppressLocation;
    }

    public void setSuppressLocation(boolean suppressLocation) {
        this.suppressLocation = suppressLocation;
    }

    public FieldInfo emitRawProperty() {
        return this.emitRawProperty;
    }

    public void setEmitRawProperty(FieldInfo emitRawProperty) {
        this.emitRawProperty = emitRawProperty;
    }

    private void emitLineNumber(Location loc) {
        if (Locations.isReal(loc)) {
            this.emitPending();
            Label label = new Label();
            this.emit(label);
            this.methodStack.peek().getGeneratorAdapter().visitLineNumber(loc.getLine(), label);
            TypeStack.TypeContext typeContext = this.typeStack.peek();
            MethodStack.MethodContext methodContext = this.methodStack.peek();
            boolean added = typeContext.setKnownCodeLocations(loc.getLine());
            if (methodContext.shouldSuppressCodeLocations() || this.suppressLocation) {
                if (added) {
                    typeContext.addSuppressedCodeLocation(loc.getLine());
                }
            } else {
                typeContext.removeSuppressedCodeLocation(loc.getLine());
            }
        } else {
            this.emitPending();
        }
    }

    private void emitPending() {
        MethodStack.MethodContext method = this.methodStack.peek();
        if (method.getPendingBox() != null) {
            assert (method.getPendingUnbox() == null);
            TypeInfo temp = method.getPendingBox();
            method.setPendingBox(null);
            this.emitBox(temp);
        } else if (method.getPendingUnbox() != null) {
            TypeInfo temp = method.getPendingUnbox();
            method.setPendingUnbox(null);
            this.emitUnbox(temp);
        }
    }

    public void unbox(TypeInfo type) {
        MethodStack.MethodContext method = this.methodStack.peek();
        if (method.getPendingBox() != null) {
            assert (method.getPendingBox() == type);
            method.setPendingBox(null);
        } else {
            method.setPendingUnbox(type);
        }
    }

    public void box(TypeInfo type) {
        MethodStack.MethodContext method = this.methodStack.peek();
        if (method.getPendingUnbox() != null) {
            assert (method.getPendingUnbox() == type);
            method.setPendingUnbox(null);
        } else {
            method.setPendingBox(type);
        }
    }

    public void emitStatementExecuted(Location loc, boolean zeroStatements, boolean trackCodeCoverage) {
        if (Locations.isReal(loc)) {
            int value = zeroStatements ? loc.getLine() : -loc.getLine();
            Location nextLoc = trackCodeCoverage ? loc : Locations.NONE;
            this.push(nextLoc, value);
            this.box(TypeInfos.INTEGER);
            this.emit(nextLoc, SystemEmitMethods.STATEMENT_EXECUTED);
        }
    }

    public void emitAdditionalCodeLocation(Location loc, String typeName) {
        if (Locations.isReal(loc)) {
            this.typeStack.peek().addAdditionalCodeLocation(loc.getLine());
            this.push(Locations.NONE, typeName);
            this.push(Locations.NONE, loc.getLine());
            this.box(TypeInfos.INTEGER);
            this.emit(Locations.NONE, SystemEmitMethods.ADDITIONAL_CODE_LOCATION_COVERED);
        }
    }

    public void emitField(Location loc, int opcode, String className, String fieldName, String typeSignature) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitFieldInsn(opcode, className, fieldName, typeSignature);
    }

    public void emitField(Location loc, int opcode, FieldInfo variable) {
        this.emitField(loc, opcode, variable.getDefiningType().getBytecodeName(), variable.getBytecodeName(), variable.getEmitType().getTypeSignature());
    }

    public void emitField(Location loc, int opcode, FieldInfo variable, TypeInfo emitType) {
        this.emitField(loc, opcode, variable.getDefiningType().getBytecodeName(), variable.getBytecodeName(), emitType.getTypeSignature());
    }

    public void emitVar(Location loc, int opcode, int position) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitVarInsn(opcode, position);
    }

    public void emitJump(Location loc, int opcode, Label branch) {
        this.emitLineNumber(loc);
        if (opcode == 168) {
            this.methodStack.peek().incrementJsrCount();
        }
        this.methodStack.peek().getGeneratorAdapter().visitJumpInsn(opcode, branch);
    }

    public void emitType(Location loc, int opcode, TypeInfo type) {
        this.emitType(loc, opcode, type.getBytecodeName());
    }

    public void emitType(Location loc, int opcode, String signature) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitTypeInsn(opcode, signature);
    }

    public void emitIinc(Location loc, int position, int value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitIincInsn(position, value);
    }

    public void emit(Location loc, int opcode) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().visitInsn(opcode);
    }

    public void emit(Location loc, AsmMethod method) {
        this.emitLineNumber(loc);
        String bytecodeSignature = method.signature.getValue();
        if (method.opcode == -1) {
            this.methodStack.peek().getGeneratorAdapter().visitInvokeDynamicInsn(method.signature.getName(), bytecodeSignature, BOOTSTRAP_METHOD, new Object[0]);
        } else {
            this.methodStack.peek().getGeneratorAdapter().visitMethodInsn(method.opcode, method.definingType, method.function, bytecodeSignature, method.definerInterface);
        }
    }

    public void emit(Label branch) {
        this.emitPending();
        this.methodStack.peek().getGeneratorAdapter().visitLabel(branch);
    }

    public void push(Location loc, String value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    public void push(Location loc, int value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    public void push(Location loc, long value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    public void push(Location loc, double value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    public void push(Location loc, boolean value) {
        this.emitLineNumber(loc);
        this.methodStack.peek().getGeneratorAdapter().push(value);
    }

    private void emitUnbox(TypeInfo pendingUnbox) {
        switch (pendingUnbox.getBasicType()) {
            case INTEGER: {
                this.emit(Locations.NONE, IntegerEmitMethods.INT_VALUE);
                break;
            }
            case LONG: {
                this.emit(Locations.NONE, LongEmitMethods.LONG_VALUE);
                break;
            }
            case DOUBLE: {
                this.emit(Locations.NONE, DoubleEmitMethods.DOUBLE_VALUE);
                break;
            }
            case BOOLEAN: {
                this.emit(Locations.NONE, BooleanEmitMethods.BOOLEAN_VALUE);
                break;
            }
        }
    }

    public void emitBox(TypeInfo pendingBox) {
        switch (pendingBox.getBasicType()) {
            case INTEGER: {
                this.emit(Locations.NONE, IntegerEmitMethods.VALUE_OF);
                break;
            }
            case LONG: {
                this.emit(Locations.NONE, LongEmitMethods.VALUE_OF);
                break;
            }
            case DOUBLE: {
                this.emit(Locations.NONE, DoubleEmitMethods.VALUE_OF);
                break;
            }
            case BOOLEAN: {
                this.emit(Locations.NONE, BooleanEmitMethods.VALUE_OF);
                break;
            }
        }
    }

    public void emitCatchBlock(Label tryStart, Label tryEnd, Label handlerStart, TypeInfo type) {
        this.methodStack.peek().getGeneratorAdapter().visitTryCatchBlock(tryStart, tryEnd, handlerStart, type.getBytecodeName());
    }

    public void emitFinallyBlock(Label tryStart, Label tryEnd, Label handlerStart) {
        this.methodStack.peek().getGeneratorAdapter().visitTryCatchBlock(tryStart, tryEnd, handlerStart, null);
    }

    public void emitLocalVariable(String name, TypeInfo type, int position) {
        if (name != null) {
            Label label = new Label();
            this.emit(label);
            this.methodStack.peek().getGeneratorAdapter().visitLocalVariable(name, TypeEraser.eraseTypeSignature(type), null, label, label, position);
        }
    }

    public ProxyMethodTable getProxyMethodTable() {
        return this.proxyMethodTable;
    }

    public Version getVersion() {
        return this.getTypeStack().peek().getCodeUnitDetails().getVersion();
    }

    public TypeInfo getType() {
        return this.getTypeStack().peek().getType();
    }

    public AccessEvaluator getAccessEvaluator() {
        return this.accessEvaluator;
    }
}

