/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import java.util.Comparator;

public final class EmitOrder
implements Comparator<Method> {
    private static final EmitOrder INSTANCE = new EmitOrder();

    private EmitOrder() {
    }

    public static EmitOrder get() {
        return INSTANCE;
    }

    @Override
    public int compare(Method leftMethod, Method rightMethod) {
        MethodInfo left = leftMethod.getMethodInfo();
        MethodInfo right = rightMethod.getMethodInfo();
        if (left.isConstructor() && !right.isConstructor()) {
            return -1;
        }
        if (!left.isConstructor() && right.isConstructor()) {
            return 1;
        }
        if (left.isConstructor() && right.isConstructor()) {
            return 0;
        }
        if (left.isPropertyAccessor() && !right.isPropertyAccessor()) {
            return 1;
        }
        if (!left.isPropertyAccessor() && right.isPropertyAccessor()) {
            return -1;
        }
        if (left.isPropertyAccessor() && right.isPropertyAccessor()) {
            return 0;
        }
        if (left.getModifiers().has(ModifierTypeInfos.STATIC) && !right.getModifiers().has(ModifierTypeInfos.STATIC)) {
            return 1;
        }
        if (!left.getModifiers().has(ModifierTypeInfos.STATIC) && right.getModifiers().has(ModifierTypeInfos.STATIC)) {
            return -1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(left.getName(), right.getName());
    }
}

