/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.parser.impl.CustomRecognitionException;
import apex.jorje.parser.impl.MatchBlocks;
import apex.jorje.parser.impl.SpecialVariableMatcher;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Optional;

public class SpecialMethodMatcher {
    private static final SpecialMethodMatcher INSTANCE = new SpecialMethodMatcher();

    private SpecialMethodMatcher() {
    }

    public static SpecialMethodMatcher get() {
        return INSTANCE;
    }

    public Expr match(Optional<Expr> rawDottedExpr, List<Identifier> rawIdentifiers, List<Expr> parameters) throws CustomRecognitionException {
        List<Identifier> identifiers;
        Optional<Expr> dottedExpr;
        if (!rawDottedExpr.isPresent() && rawIdentifiers.size() > 1) {
            Location loc = Locations.from(rawIdentifiers.get(0).getLoc(), rawIdentifiers.get(rawIdentifiers.size() - 2).getLoc());
            Identifier lastIdentifier = Iterables.getLast(rawIdentifiers);
            Expr expr = SpecialVariableMatcher.get().match(Optional.empty(), loc, MoreLists.removeLast(rawIdentifiers));
            dottedExpr = expr.match(MatchBlocks.GET_DOTTED_EXPR);
            identifiers = MoreLists.appendList(expr.match(MatchBlocks.GET_IDENTIFIERS), lastIdentifier);
        } else {
            dottedExpr = rawDottedExpr;
            identifiers = rawIdentifiers;
        }
        return Expr._MethodCallExpr(dottedExpr, identifiers, parameters);
    }
}

