/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.jorje.data.errors.LexicalError;
import apex.jorje.data.errors.UserError;
import apex.jorje.parser.impl.BaseApexLexer;
import apex.jorje.parser.impl.CustomRecognitionException;
import apex.jorje.services.datetimes.DateTimeFormats;
import com.google.common.collect.ImmutableMap;
import java.time.DateTimeException;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.function.Function;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognizerSharedState;

public class DateTimeToken
extends CommonToken {
    static final Map<Integer, Function<String, Temporal>> TYPE_TO_FORMAT = ImmutableMap.builder().put(39, DateTimeFormats::fromDate).put(169, DateTimeFormats::fromTime).put(41, DateTimeFormats::fromDateTime).build();
    private static final long serialVersionUID = 4308356384614685354L;
    private final Temporal temporal;

    private DateTimeToken(CharStream input, int type, RecognizerSharedState state, int tokenEndCharIndex, String tokenInput) {
        super(input, type, 0, state.tokenStartCharIndex, tokenEndCharIndex);
        this.setLine(state.tokenStartLine);
        this.setCharPositionInLine(state.tokenStartCharPositionInLine);
        this.temporal = TYPE_TO_FORMAT.get(type).apply(tokenInput);
    }

    public static DateTimeToken create(BaseApexLexer lexer, CharStream input, RecognizerSharedState state, int tokenEndCharIndex) throws CustomRecognitionException {
        String tokenInput = input.substring(state.tokenStartCharIndex, tokenEndCharIndex);
        switch (lexer.lexing) {
            case DATE: {
                try {
                    return new DateTimeToken(input, 39, state, tokenEndCharIndex, tokenInput);
                }
                catch (DateTimeException x) {
                    throw new CustomRecognitionException(UserError._Lexical(LexicalError._InvalidDate(lexer.createCurrentLoc(), tokenInput)));
                }
            }
            case DATE_TIME: {
                try {
                    return new DateTimeToken(input, 41, state, tokenEndCharIndex, tokenInput);
                }
                catch (DateTimeException x) {
                    throw new CustomRecognitionException(UserError._Lexical(LexicalError._InvalidDateTime(lexer.createCurrentLoc(), tokenInput)));
                }
            }
            case TIME: {
                try {
                    return new DateTimeToken(input, 169, state, tokenEndCharIndex, tokenInput);
                }
                catch (DateTimeException x) {
                    throw new CustomRecognitionException(UserError._Lexical(LexicalError._InvalidTime(lexer.createCurrentLoc(), tokenInput)));
                }
            }
        }
        throw new IllegalArgumentException("Invalid type.");
    }

    Temporal getTemporal() {
        return this.temporal;
    }
}

