/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.common.base.MoreStrings;
import apex.common.base.WeakStringInterner;
import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.data.errors.SyntaxError;
import apex.jorje.data.errors.UserError;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.data.soql.QueryOption;
import apex.jorje.data.soql.UpdateStatsOption;
import apex.jorje.parser.impl.CustomRecognitionException;
import apex.jorje.parser.impl.ErrorLogger;
import apex.jorje.services.Version;
import apex.jorje.services.exception.InternalException;
import apex.jorje.services.exception.ParseException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MismatchedTreeNodeException;
import org.antlr.runtime.MissingTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.UnwantedTokenException;

public abstract class BaseApexParser
extends Parser
implements ErrorLogger {
    private static final Set<String> VALID_AMBIGUOUS_USING = ImmutableSet.of("scope", "lookup");
    private static String[] PARAPHRASE_TOKEN_NAMES;
    private final List<ParseException> syntaxErrorReporter = new ArrayList<ParseException>();
    private final List<InternalException> internalErrorReporter = new ArrayList<InternalException>();
    private Version version = Version.CURRENT;

    public BaseApexParser(TokenStream tokens, RecognizerSharedState state) {
        super(tokens, state);
        if (PARAPHRASE_TOKEN_NAMES == null) {
            PARAPHRASE_TOKEN_NAMES = this.createParaphrase();
        }
    }

    static <T> TokenPair<T> tokenPair(Token token, T value) {
        return new TokenPair<T>(token, value);
    }

    private synchronized String[] createParaphrase() {
        String[] tokenNames = this.getTokenNames();
        String[] paraphrase = (String[])Arrays.copyOf(tokenNames, tokenNames.length, tokenNames.getClass());
        paraphrase[108] = "<";
        paraphrase[75] = ">";
        paraphrase[110] = "=>";
        paraphrase[14] = "&";
        paraphrase[15] = "|";
        paraphrase[8] = "&=";
        paraphrase[129] = "|=";
        paraphrase[102] = "&&";
        paraphrase[104] = "||";
        paraphrase[103] = "!";
        paraphrase[16] = "^";
        paraphrase[60] = "=";
        paraphrase[54] = "==";
        paraphrase[121] = "!=";
        paraphrase[6] = "<>";
        paraphrase[175] = "===";
        paraphrase[122] = "!==";
        paraphrase[138] = "?";
        paraphrase[32] = ",";
        paraphrase[53] = ".";
        paraphrase[154] = "/";
        paraphrase[106] = "(";
        paraphrase[144] = ")";
        paraphrase[151] = ";";
        paraphrase[31] = ":";
        paraphrase[107] = "[";
        paraphrase[145] = "]";
        paraphrase[96] = "{";
        paraphrase[139] = "}";
        paraphrase[11] = "@";
        paraphrase[168] = "~";
        paraphrase[132] = "+";
        paraphrase[133] = "+=";
        paraphrase[170] = "*";
        paraphrase[171] = "*=";
        paraphrase[49] = "/";
        paraphrase[50] = "/=";
        paraphrase[112] = "-";
        paraphrase[113] = "-=";
        paraphrase[134] = "++";
        paraphrase[114] = "--";
        return paraphrase;
    }

    Identifier getIdentifier(Token token) {
        return Identifiers.newIdentifier(this.tokenLoc(token), WeakStringInterner.get().intern(MoreObjects.firstNonNull(token.getText(), "")));
    }

    Token getToken(TokenPair<?> pair) {
        return pair == null ? this.input.LT(1) : pair.token;
    }

    protected <T> T getValue(TokenPair<T> pair) {
        return pair == null ? null : (T)pair.value;
    }

    @Override
    public List<ParseException> getParseErrors() {
        return this.syntaxErrorReporter;
    }

    @Override
    public List<InternalException> getInternalErrors() {
        return this.internalErrorReporter;
    }

    Location tokenLoc(Token token) {
        return this.tokenLoc(token, token);
    }

    Location tokenLoc(Expr expr, Token endToken) {
        return expr == null ? this.tokenLoc(endToken) : Locations.from(Locations.from(expr), this.tokenLoc(endToken));
    }

    String toString(Token start, Token stop) {
        Token t;
        if (start == null || stop == null) {
            throw new IllegalArgumentException("Start/stop was null.");
        }
        StringBuilder buf = new StringBuilder();
        for (int i = start.getTokenIndex(); i <= stop.getTokenIndex() && (t = this.input.get(i)).getType() != -1; ++i) {
            if (t.getType() == 159) {
                buf.append("'").append(t.getText()).append("'");
                continue;
            }
            buf.append(t.getText());
        }
        return buf.toString();
    }

    public Location tokenLoc(Token startToken, Token endToken) {
        int startRow = startToken.getLine();
        int startColumn = startToken.getCharPositionInLine() + 1;
        int startIndex = this.getStartIndex(startToken);
        int endIndex = this.getEndIndex(endToken) + 1;
        return Locations.loc(startIndex, endIndex, startRow, startColumn);
    }

    private int getStartIndex(Token startToken) {
        if (startToken instanceof CommonToken) {
            CommonToken ct = (CommonToken)startToken;
            return ct.getStartIndex();
        }
        String message = "Non CommonToken " + this.getTokenName(startToken.getType()) + " with content '" + startToken.getText() + "' on channel " + startToken.getChannel();
        this.internalErrorReporter.add(InternalException.create("unrecognized token on hidden channel", message));
        return -1;
    }

    private int getEndIndex(Token endToken) {
        if (endToken instanceof CommonToken) {
            CommonToken ct = (CommonToken)endToken;
            return ct.getStopIndex();
        }
        String message = "Non CommonToken " + this.getTokenName(endToken.getType()) + " with content '" + endToken.getText() + "' on channel " + endToken.getChannel();
        this.internalErrorReporter.add(InternalException.create("unrecognized token on hidden channel", message));
        return -1;
    }

    private String getTokenName(int tokenType) {
        return tokenType == -1 ? "<EOF>" : PARAPHRASE_TOKEN_NAMES[tokenType];
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException exception) {
        if (exception instanceof CustomRecognitionException) {
            CustomRecognitionException ex = (CustomRecognitionException)exception;
            this.reportUserError(ex.getError(), ex);
        } else {
            String text = Strings.nullToEmpty(exception.token.getText());
            Location loc = Locations.loc(exception.index, exception.index + text.length(), exception.line, exception.charPositionInLine + 1);
            if (exception instanceof UnwantedTokenException) {
                UnwantedTokenException unwantedTokenException = (UnwantedTokenException)exception;
                String expectedToken = this.getTokenName(unwantedTokenException.expecting);
                String input = this.getTokenErrorDisplay(exception.token);
                this.reportSyntaxError(SyntaxError._UnmatchedSyntax(loc, input, expectedToken), exception);
            } else if (exception instanceof MissingTokenException) {
                MissingTokenException missingTokenException = (MissingTokenException)exception;
                String expectedToken = this.getTokenName(missingTokenException.expecting);
                String input = this.getTokenErrorDisplay(exception.token);
                this.reportSyntaxError(SyntaxError._MissingSyntax(loc, input, expectedToken), exception);
            } else if (exception instanceof MismatchedTokenException) {
                MismatchedTokenException mismatchedTokenException = (MismatchedTokenException)exception;
                String expectedToken = this.getTokenName(mismatchedTokenException.expecting);
                String input = this.getTokenErrorDisplay(exception.token);
                this.reportSyntaxError(SyntaxError._MismatchedSyntax(loc, input, expectedToken), exception);
            } else if (exception instanceof MismatchedTreeNodeException) {
                MismatchedTreeNodeException mismatchedTreeNodeException = (MismatchedTreeNodeException)exception;
                String expectedToken = this.getTokenName(mismatchedTreeNodeException.expecting);
                String input = String.valueOf(mismatchedTreeNodeException.node);
                this.reportSyntaxError(SyntaxError._MismatchedSyntax(loc, input, expectedToken), exception);
            } else if (exception instanceof NoViableAltException) {
                String input = this.getTokenErrorDisplay(exception.token);
                this.reportSyntaxError(SyntaxError._UnexpectedToken(loc, input), exception);
            } else if (exception instanceof EarlyExitException) {
                String input = this.getTokenErrorDisplay(exception.token);
                this.reportSyntaxError(SyntaxError._UnexpectedToken(loc, input), exception);
            } else {
                String message = this.getErrorMessage(exception, PARAPHRASE_TOKEN_NAMES);
                this.reportSyntaxError(SyntaxError._UnexpectedSyntaxError(loc, message), exception);
            }
        }
    }

    List<Identifier> parseIdentifier(Identifier identifier) {
        if (identifier == null || identifier.getValue() == null) {
            return null;
        }
        List<String> split = Splitter.on(".").splitToList(identifier.getValue());
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>(split.size());
        Location bigLoc = identifier.getLoc();
        int offset = 0;
        for (int i = 0; i < split.size(); ++i) {
            String value = split.get(i);
            int length = value.length();
            Location loc = Locations.loc(bigLoc.getStartIndex() + offset, bigLoc.getStartIndex() + offset + length, bigLoc.getLine(), bigLoc.getColumn() + offset);
            identifiers.add(Identifiers.newIdentifier(loc, WeakStringInterner.get().intern(value)));
            offset += length + 1;
        }
        return identifiers;
    }

    Identifier validateSingleIdentifier(Identifier identifier) throws CustomRecognitionException {
        if (identifier != null && identifier.getValue() != null && identifier.getValue().indexOf(46) > -1) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._UnexpectedToken(identifier.getLoc(), "'.'")));
        }
        return identifier;
    }

    Identifier validateInheritedIdentifier(Identifier identifier) throws CustomRecognitionException {
        if (identifier != null && !MoreStrings.equalsIgnoreCase(identifier.getValue(), "inherited")) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._UnexpectedToken(identifier.getLoc(), identifier.getValue())));
        }
        return identifier;
    }

    FieldIdentifier parseFieldIdentifier(Identifier identifier) {
        List<Identifier> identifiers = this.parseIdentifier(identifier);
        if (identifiers == null || identifiers.isEmpty()) {
            return null;
        }
        FieldIdentifier field = null;
        for (int i = 0; i < identifiers.size(); ++i) {
            field = FieldIdentifier._FieldIdentifier(Optional.ofNullable(field), identifiers.get(i));
        }
        return field;
    }

    Integer parseInteger(Token t) throws CustomRecognitionException {
        try {
            return Integer.valueOf(t.getText());
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalIntegerLiteral(this.tokenLoc(t))));
        }
    }

    Long parseLong(Token t) throws CustomRecognitionException {
        try {
            return Long.valueOf(t.getText().substring(0, t.getText().length() - 1));
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalLongLiteral(this.tokenLoc(t))));
        }
    }

    Double parseDouble(Token t) throws CustomRecognitionException {
        try {
            return Double.valueOf(t.getText().substring(0, t.getText().length() - 1));
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalDoubleLiteral(this.tokenLoc(t))));
        }
    }

    Expr.LiteralExpr createDecimal(Token t) throws RecognitionException {
        try {
            return this.getVersion().isGreaterThanOrEqual(Version.V162) ? new Expr.LiteralExpr(this.tokenLoc(t), LiteralType.DECIMAL, this.parseDecimal(t)) : new Expr.LiteralExpr(this.tokenLoc(t), LiteralType.DOUBLE, Double.valueOf(t.getText()));
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalDecimalLiteral(this.tokenLoc(t))));
        }
    }

    BigDecimal parseDecimal(Token t) throws CustomRecognitionException {
        try {
            if (t.getText().length() > 50) {
                throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalDecimalLiteral(this.tokenLoc(t))));
            }
            return new BigDecimal(t.getText());
        }
        catch (NumberFormatException x) {
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._IllegalDecimalLiteral(this.tokenLoc(t))));
        }
    }

    TypeRef parseType(List<Identifier> names, List<TypeRef> typeArguments, boolean isJavaRef) throws CustomRecognitionException {
        if (isJavaRef) {
            if (typeArguments.isEmpty()) {
                return TypeRefs.newJavaTypeRef(names);
            }
            throw new CustomRecognitionException(UserError._Syntax(SyntaxError._UnexpectedToken(Locations.from(names), "'<'")));
        }
        return TypeRefs.newClassTypeRef(names, typeArguments);
    }

    UpdateStatsOption parseUpdateStatsOption(Identifier name) throws CustomRecognitionException {
        if (MoreStrings.equalsIgnoreCase("viewstat", name.getValue())) {
            return UpdateStatsOption._UpdateViewStat(name.getLoc());
        }
        if (MoreStrings.equalsIgnoreCase("tracking", name.getValue())) {
            return UpdateStatsOption._UpdateTracking(name.getLoc());
        }
        throw new CustomRecognitionException(UserError._Syntax(SyntaxError._UnexpectedToken(name.getLoc(), "'" + name.getValue() + "'")));
    }

    QueryOption parseIncludeDeleted(Identifier all, Identifier rows) throws CustomRecognitionException {
        if (MoreStrings.equalsIgnoreCase("all", all.getValue())) {
            if (MoreStrings.equalsIgnoreCase("rows", rows.getValue())) {
                return QueryOption._IncludeDeleted(Locations.from(all.getLoc(), rows.getLoc()));
            }
            UserError error = UserError._Syntax(SyntaxError._UnexpectedToken(rows.getLoc(), "'" + rows.getValue() + "'"));
            throw new CustomRecognitionException(error);
        }
        UserError error = UserError._Syntax(SyntaxError._UnexpectedToken(all.getLoc(), "'" + all.getValue() + "'"));
        throw new CustomRecognitionException(error);
    }

    private void reportUserError(UserError error, RecognitionException cause) {
        this.syntaxErrorReporter.add(ParseException.create(error, cause));
    }

    private void reportSyntaxError(SyntaxError error, RecognitionException cause) {
        this.reportUserError(UserError._Syntax(error), cause);
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean isValidUsing(Identifier identifier) {
        if (identifier == null || identifier.getValue() == null) {
            return false;
        }
        String value = identifier.getValue().toLowerCase();
        return VALID_AMBIGUOUS_USING.contains(value);
    }

    protected static class TokenPair<T> {
        public final Token token;
        public final T value;

        public TokenPair(Token token, T value) {
            this.token = token;
            this.value = value;
        }
    }
}

