/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.errors.LexicalError;
import apex.jorje.data.errors.UserError;
import apex.jorje.parser.impl.ApexLexer;
import apex.jorje.parser.impl.CustomRecognitionException;
import apex.jorje.parser.impl.DateTimeToken;
import apex.jorje.parser.impl.ErrorLogger;
import apex.jorje.parser.impl.TokenSourceDecorator;
import apex.jorje.services.exception.InternalException;
import apex.jorje.services.exception.ParseException;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedRangeException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;

public abstract class BaseApexLexer
extends Lexer
implements ErrorLogger,
TokenSourceDecorator {
    private static final Logger LOGGER = Logger.getLogger(BaseApexLexer.class.getName());
    private static final ReentrantReadWriteLock INIT_LOCK = new ReentrantReadWriteLock();
    private static boolean INITIALIZED = false;
    private final List<ParseException> syntaxErrorReporter;
    private final List<InternalException> internalErrorReporter;
    Lexing lexing = Lexing.OTHER;
    private boolean consume = true;

    BaseApexLexer() {
        BaseApexLexer.init();
        this.syntaxErrorReporter = new ArrayList<ParseException>();
        this.internalErrorReporter = new ArrayList<InternalException>();
    }

    BaseApexLexer(CharStream input, RecognizerSharedState state) {
        super(input, state);
        BaseApexLexer.init();
        this.syntaxErrorReporter = new ArrayList<ParseException>();
        this.internalErrorReporter = new ArrayList<InternalException>();
    }

    private static void init() {
        block7: {
            INIT_LOCK.readLock().lock();
            try {
                if (INITIALIZED) break block7;
                INIT_LOCK.readLock().unlock();
                INIT_LOCK.writeLock().lock();
                try {
                    if (!INITIALIZED) {
                        BaseApexLexer.dedupe("DFA22_transition", ApexLexer.DFA22_transition);
                        INITIALIZED = true;
                    }
                }
                finally {
                    INIT_LOCK.readLock().lock();
                    INIT_LOCK.writeLock().unlock();
                }
            }
            finally {
                INIT_LOCK.readLock().unlock();
            }
        }
    }

    private static void dedupe(String name, short[][] s) {
        Stopwatch timer = Stopwatch.createStarted();
        int removedShorts = 0;
        int totalShorts = 0;
        for (int i = 0; i < s.length; ++i) {
            int shortsInDisArray = s[i].length;
            totalShorts += shortsInDisArray;
            for (int j = i + 1; j < s.length; ++j) {
                if (s[i] == s[j] || !Arrays.equals(s[i], s[j])) continue;
                removedShorts += shortsInDisArray;
                s[j] = s[i];
            }
        }
        timer.stop();
        LOGGER.info("Deduped array ApexLexer." + name + ". Found " + totalShorts + " shorts which is " + BaseApexLexer.megs(totalShorts) + "MB not including array overhead. Removed " + removedShorts + " shorts which is " + BaseApexLexer.megs(removedShorts) + "MB not counting array overhead. Took " + timer.elapsed(TimeUnit.MILLISECONDS) + " ms.");
    }

    private static int megs(int shorts) {
        return shorts * 2 / 0x100000;
    }

    @Override
    public List<ParseException> getParseErrors() {
        return this.syntaxErrorReporter;
    }

    @Override
    public List<InternalException> getInternalErrors() {
        return this.internalErrorReporter;
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException x) {
        RecognitionException exception;
        switch (this.lexing) {
            case TIME: {
                exception = this.throwInvalidTime(this.getText());
                break;
            }
            case DATE_TIME: {
                exception = this.throwInvalidDateTime(this.getText());
                break;
            }
            case DATE: {
                exception = this.throwInvalidDate(this.getText());
                break;
            }
            case OTHER: {
                exception = x;
                break;
            }
            default: {
                throw new IllegalArgumentException("lexing type not defined");
            }
        }
        this.lexing = Lexing.OTHER;
        this.consume = true;
        if (exception instanceof CustomRecognitionException) {
            CustomRecognitionException customException = (CustomRecognitionException)exception;
            this.reportUserError(customException.getError(), customException);
            this.consume = false;
        } else if (exception != null) {
            this.reportInternalUncategorizedSyntaxError(exception, tokenNames);
            int tokenLen = 0;
            if (exception.token != null) {
                tokenLen = exception.token.getText().length();
            }
            Location loc = Locations.loc(exception.index, exception.index + tokenLen, exception.line, exception.charPositionInLine + 1);
            String found = this.getCharInfoForError(exception.c);
            if (exception instanceof NoViableAltException) {
                this.reportSyntaxError(LexicalError._UnrecognizedSymbol(loc, found), exception);
            } else if (exception instanceof MismatchedTokenException) {
                MismatchedTokenException ex = (MismatchedTokenException)exception;
                String expected = this.getCharInfoForError(ex.expecting);
                this.reportSyntaxError(LexicalError._UnexpectedSymbol(loc, found, expected), exception);
            } else if (exception instanceof MismatchedNotSetException) {
                MismatchedNotSetException ex = (MismatchedNotSetException)exception;
                Set<String> unexpected = this.getCharInfoForError(ex.expecting);
                this.reportSyntaxError(LexicalError._SymbolInUnexpectedSet(loc, found, unexpected), exception);
            } else if (exception instanceof MismatchedSetException) {
                MismatchedSetException ex = (MismatchedSetException)exception;
                Set<String> expected = this.getCharInfoForError(ex.expecting);
                this.reportSyntaxError(LexicalError._SymbolNotInExpectedSet(loc, found, expected), exception);
            } else if (exception instanceof MismatchedRangeException) {
                MismatchedRangeException ex = (MismatchedRangeException)exception;
                String begin = this.getCharInfoForError(ex.a);
                String end = this.getCharInfoForError(ex.b);
                this.reportSyntaxError(LexicalError._SymbolNotInRange(loc, found, begin, end), exception);
            } else {
                String message = this.getErrorMessage(exception, tokenNames);
                this.reportSyntaxError(LexicalError._UnexpectedLexicalError(loc, message), exception);
            }
        }
    }

    private void reportUserError(UserError error, RecognitionException cause) {
        this.syntaxErrorReporter.add(ParseException.create(error, cause));
    }

    private void reportSyntaxError(LexicalError error, RecognitionException cause) {
        this.reportUserError(UserError._Lexical(error), cause);
    }

    private void reportInternalUncategorizedSyntaxError(RecognitionException ex, String[] tokenNames) {
        String message = this.getErrorMessage(ex, tokenNames);
        String context = this.context();
        String shortMessage = "UnexpectedSyntaxError which was not categorized properly.";
        String detailedMessage = context + ". Message was \"" + message + "\".";
        this.internalErrorReporter.add(InternalException.create("UnexpectedSyntaxError which was not categorized properly.", detailedMessage, ex));
    }

    private String context() {
        int size;
        int n = size = this.input != null ? this.input.size() : 0;
        if (size > 0) {
            int start = Math.min(size - 1, Math.max(0, this.state.tokenStartCharIndex));
            int targetEnd = this.getCharIndex();
            int end = Math.min(targetEnd, size - 1);
            return this.input.substring(start, end);
        }
        return "";
    }

    Set<String> getCharInfoForError(BitSet s) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        if (s == null) {
            return results;
        }
        int possibleSize = s.numBits();
        for (int i = 0; i < possibleSize; ++i) {
            if (!s.member(i)) continue;
            results.add(this.getCharInfoForError(i));
        }
        return results;
    }

    String getCharInfoForError(int c) {
        String s;
        switch (c) {
            case -1: {
                s = "<EOF>";
                break;
            }
            case 10: {
                s = "\\n";
                break;
            }
            case 9: {
                s = "\\t";
                break;
            }
            case 13: {
                s = "\\r";
                break;
            }
            case 8: {
                s = "\\b";
                break;
            }
            case 12: {
                s = "\\f";
                break;
            }
            default: {
                s = String.valueOf((char)c);
            }
        }
        return s;
    }

    Location createCurrentLoc() {
        try {
            return Locations.loc(this.state.tokenStartCharIndex, this.getCharIndex(), this.state.tokenStartLine, this.state.tokenStartCharPositionInLine + 1);
        }
        catch (NullPointerException e) {
            return Locations.NONE;
        }
    }

    private void throwCustomRecognitionException(LexicalError error) throws RecognitionException {
        throw new CustomRecognitionException(UserError._Lexical(error));
    }

    void throwUnterminatedString(String quote) throws RecognitionException {
        this.throwCustomRecognitionException(LexicalError._UnterminatedString(this.createCurrentLoc(), quote));
    }

    void throwUnterminatedComment(String closeComment) throws RecognitionException {
        this.throwCustomRecognitionException(LexicalError._UnterminatedComment(this.createCurrentLoc(), closeComment));
    }

    void throwInvalidIdentifier(String identifier) throws RecognitionException {
        this.throwCustomRecognitionException(LexicalError._InvalidIdentifier(this.createCurrentLoc(), identifier));
    }

    void throwInvalidSymbol(String symbol) throws RecognitionException {
        if (symbol.length() == 1) {
            this.throwCustomRecognitionException(LexicalError._InvalidSymbol(this.createCurrentLoc(), symbol.charAt(0)));
        } else {
            this.internalErrorReporter.add(InternalException.create("Got an invalid symbol that was not 1 character", "symbol was '" + symbol + "'"));
            this.throwCustomRecognitionException(LexicalError._UnrecognizedSymbol(this.createCurrentLoc(), symbol));
        }
    }

    void throwInvalidControlChar(String symbol) throws RecognitionException {
        if (symbol.length() == 1) {
            this.throwCustomRecognitionException(LexicalError._InvalidControlChar(this.createCurrentLoc(), symbol.charAt(0)));
        } else {
            this.internalErrorReporter.add(InternalException.create("Got an invalid control char that was not 1 character", "symbol was '" + symbol + "'"));
            this.throwCustomRecognitionException(LexicalError._UnrecognizedSymbol(this.createCurrentLoc(), symbol));
        }
    }

    DateTimeToken createDateTime() throws CustomRecognitionException {
        return DateTimeToken.create(this, this.input, this.state, this.getCharIndex() - 1);
    }

    private CustomRecognitionException throwInvalidTime(String time) {
        LexicalError error = LexicalError._InvalidTime(this.createCurrentLoc(), time);
        return new CustomRecognitionException(UserError._Lexical(error));
    }

    private CustomRecognitionException throwInvalidDateTime(String dateTime) {
        LexicalError error = LexicalError._InvalidDateTime(this.createCurrentLoc(), dateTime);
        return new CustomRecognitionException(UserError._Lexical(error));
    }

    private CustomRecognitionException throwInvalidDate(String dateTime) {
        LexicalError error = LexicalError._InvalidDate(this.createCurrentLoc(), dateTime);
        return new CustomRecognitionException(UserError._Lexical(error));
    }

    public void recover(RecognitionException re) {
        switch (this.lexing) {
            case TIME: 
            case DATE_TIME: 
            case DATE: {
                break;
            }
            case OTHER: {
                if (!this.consume || re instanceof CustomRecognitionException) break;
                super.recover(re);
                break;
            }
            default: {
                throw new IllegalArgumentException("lexing type not defined");
            }
        }
        this.consume = true;
    }

    static enum Lexing {
        TIME,
        DATE,
        DATE_TIME,
        OTHER;

    }
}

