/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.workspace;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.document.StandardDocument;
import apex.jorje.lsp.impl.index.SfdxProject;
import apex.jorje.lsp.impl.utils.SfdxProjects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class StandardApexDocumentService
implements ApexDocumentService {
    private static final Logger logger = LoggerFactory.getLogger(StandardApexDocumentService.class);
    private final Map<URI, String> sources = new ConcurrentHashMap<URI, String>();
    private final Map<URI, String> namespaces = new ConcurrentHashMap<URI, String>();
    private final SfdxProjects sfdxProjectUtil;

    @Inject
    public StandardApexDocumentService(SfdxProjects sfdxProjectUtil) {
        this.sfdxProjectUtil = sfdxProjectUtil;
    }

    @Override
    public void store(URI uri, String source) {
        this.store(uri, source, this.getNamespaceForFile(uri));
    }

    private String getNamespaceForFile(URI uri) {
        Optional<SfdxProject> sfdxProject = this.sfdxProjectUtil.constructSfdxProject();
        if (sfdxProject.isPresent()) {
            return this.sfdxProjectUtil.getNamespaceForFile(Paths.get(uri), sfdxProject.get());
        }
        return "";
    }

    @Override
    public void store(URI uri, String source, String namespace) {
        assert (source != null);
        if (Objects.equals(uri.getScheme(), "file")) {
            this.sources.put(uri, source);
            this.namespaces.put(uri, namespace);
        }
    }

    @Override
    public Optional<Document> retrieve(URI uri) {
        String source = this.sources.get(uri);
        if (source != null) {
            return Optional.of(new StandardDocument(uri, source));
        }
        if (Objects.equals(uri.getScheme(), "file")) {
            try {
                return Optional.of(new StandardDocument(uri, new String(Files.readAllBytes(Paths.get(uri)))));
            }
            catch (IOException ioe) {
                logger.info("Failed to retrieve contents of {}", (Object)uri, (Object)ioe);
            }
        }
        return Optional.empty();
    }

    @Override
    public String retrieveNamespace(URI uri) {
        String namespace = this.namespaces.get(uri);
        if (namespace != null) {
            return namespace;
        }
        String newNamespace = this.getNamespaceForFile(uri);
        if (!newNamespace.isEmpty()) {
            this.namespaces.put(uri, newNamespace);
        }
        return newNamespace;
    }

    @Override
    public void remove(URI uri) {
        String removed = this.sources.remove(uri);
        this.namespaces.remove(uri);
        if (removed == null) {
            logger.info("Tried to remove an entry {} that has no value", (Object)uri);
        }
    }
}

