/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.lsp.impl.utils.Symbols;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.SymbolInformation;

public class StandardDocumentSymbolVisitor
extends AstVisitor<AdditionalPassScope> {
    private final Symbols symbols;
    private final URI uri;
    private final List<SymbolInformation> symbolInformation = new ArrayList<SymbolInformation>();

    @AssistedInject
    public StandardDocumentSymbolVisitor(Symbols symbols, @Assisted URI uri) {
        this.symbols = symbols;
        this.uri = uri;
    }

    public List<SymbolInformation> getSymbolInformation() {
        return this.symbolInformation;
    }

    @Override
    public boolean visit(UserClass node, AdditionalPassScope scope) {
        return true;
    }

    @Override
    public void visitEnd(UserClass node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.symbolInformation.add(this.symbols.from(this.uri, node));
    }

    @Override
    public boolean visit(UserEnum node, AdditionalPassScope scope) {
        return true;
    }

    @Override
    public void visitEnd(UserEnum node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.symbolInformation.add(this.symbols.from(this.uri, node));
    }

    @Override
    public boolean visit(UserInterface node, AdditionalPassScope scope) {
        return true;
    }

    @Override
    public void visitEnd(UserInterface node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.symbolInformation.add(this.symbols.from(this.uri, node));
    }

    @Override
    public boolean visit(UserTrigger node, AdditionalPassScope scope) {
        return true;
    }

    @Override
    public void visitEnd(UserTrigger node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.symbolInformation.add(this.symbols.from(this.uri, node));
    }

    @Override
    public void visitEnd(Property node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.symbolInformation.add(this.symbols.from(this.uri, node));
    }

    @Override
    public void visitEnd(Field node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        this.symbolInformation.add(this.symbols.from(this.uri, node));
    }

    @Override
    public void visitEnd(Method node, AdditionalPassScope scope) {
        super.visitEnd(node, scope);
        if (!this.symbols.isGenerated(node)) {
            this.symbolInformation.add(this.symbols.from(this.uri, node));
        }
    }
}

