/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors;

import apex.jorje.lsp.impl.visitors.FieldNameConflictScope;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.CatchBlockStatement;
import apex.jorje.semantic.ast.statement.ForEachStatement;
import apex.jorje.semantic.ast.statement.ForLoopStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.TypeWhenBlock;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import java.util.Collection;

public class FieldNameConflictVisitor
extends AstVisitor<FieldNameConflictScope> {
    @Override
    protected boolean defaultVisit() {
        return true;
    }

    @Override
    public void visitEnd(UserClass userClass, FieldNameConflictScope scope) {
        if (!scope.getNodeHavingConflict().isPresent() && userClass.getDefiningType() != null && TypeInfoUtil.isInnerType(userClass.getDefiningType())) {
            if (userClass.getDefiningType().fields().all().stream().map(Member::getName).anyMatch(scope.getNewName()::equalsIgnoreCase) && userClass.getBodyLoc().getStartIndex() <= scope.getOffset() && userClass.getBodyLoc().getEndIndex() >= scope.getOffset()) {
                scope.setNodeHavingConflict(userClass);
            }
        }
    }

    @Override
    public void visitEnd(BlockStatement blockStatement, FieldNameConflictScope scope) {
        if (!scope.getNodeHavingConflict().isPresent()) {
            super.visitEnd(blockStatement, scope);
            this.checkForNameConflict(scope, blockStatement, blockStatement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(CatchBlockStatement catchStatement, FieldNameConflictScope scope) {
        if (!scope.getNodeHavingConflict().isPresent()) {
            super.visitEnd(catchStatement, scope);
            this.checkForNameConflict(scope, catchStatement, catchStatement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(ForEachStatement forEachStatement, FieldNameConflictScope scope) {
        if (!scope.getNodeHavingConflict().isPresent()) {
            super.visitEnd(forEachStatement, scope);
            this.checkForNameConflict(scope, forEachStatement, forEachStatement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(ForLoopStatement forLoopStatement, FieldNameConflictScope scope) {
        if (!scope.getNodeHavingConflict().isPresent()) {
            super.visitEnd(forLoopStatement, scope);
            this.checkForNameConflict(scope, forLoopStatement.getBody(), forLoopStatement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(IfElseBlockStatement ifElseBlockStatement, FieldNameConflictScope scope) {
        if (!scope.getNodeHavingConflict().isPresent()) {
            super.visitEnd(ifElseBlockStatement, scope);
            this.checkForNameConflict(scope, ifElseBlockStatement, ifElseBlockStatement.getLocals().all());
        }
    }

    @Override
    public void visitEnd(TypeWhenBlock typeWhenBlock, FieldNameConflictScope scope) {
        if (!scope.getNodeHavingConflict().isPresent()) {
            super.visitEnd(typeWhenBlock, scope);
            this.checkForNameConflict(scope, typeWhenBlock.getBlock(), typeWhenBlock.getLocals().all());
        }
    }

    @Override
    public void visitEnd(Method method, FieldNameConflictScope scope) {
        if (!scope.getNodeHavingConflict().isPresent()) {
            super.visitEnd(method, scope);
            this.checkForNameConflict(scope, method.getBody(), method.getLocals().all());
        }
    }

    private void checkForNameConflict(FieldNameConflictScope scope, Statement statement, Collection<LocalInfo> locals) {
        if (!locals.stream().map(LocalInfo::getName).anyMatch(scope.getNewName()::equalsIgnoreCase)) {
            return;
        }
        if (statement.getLoc().getStartIndex() <= scope.getOffset() && statement.getLoc().getEndIndex() >= scope.getOffset()) {
            scope.setNodeHavingConflict(statement);
        }
    }
}

