/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.lsp.impl.index.ApexIndexer;
import apex.jorje.lsp.impl.index.SfdxProject;
import apex.jorje.lsp.impl.index.SfdxProjectPOJO;
import apex.jorje.lsp.impl.workspace.ServerSetup;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SfdxProjects {
    private static final String NAMESPACE_FILE = "installed-package.json";
    private static final Logger logger = LoggerFactory.getLogger(SfdxProjects.class);
    private final Provider<ServerSetup> serverSetupProvider;

    @Inject
    public SfdxProjects(Provider<ServerSetup> serverSetupProvider) {
        this.serverSetupProvider = serverSetupProvider;
    }

    public synchronized Optional<SfdxProject> constructSfdxProject() {
        SfdxProject sfdxProject = null;
        Path sfdxProjectFilePath = Paths.get(((ServerSetup)this.serverSetupProvider.get()).getRootPath(), "sfdx-project.json");
        if (Files.exists(sfdxProjectFilePath, new LinkOption[0])) {
            try {
                sfdxProject = SfdxProject.from(new String(Files.readAllBytes(sfdxProjectFilePath)), (ServerSetup)this.serverSetupProvider.get());
            }
            catch (IOException ioe) {
                logger.error("Failed to retrieve contents of {}", (Object)sfdxProjectFilePath, (Object)ioe);
            }
            catch (JsonSyntaxException jse) {
                logger.error("Contents of {} is invalid json", (Object)sfdxProjectFilePath, (Object)jse);
            }
        }
        return Optional.ofNullable(sfdxProject);
    }

    public synchronized Map<String, Set<URI>> getSfdxFiles(SfdxProject sfdxProject) {
        HashMap<String, Set<URI>> mapApexUris = Maps.newHashMap();
        this.visitSfdxFiles(sfdxProject, new StandardProjectFileVisitor(mapApexUris));
        return mapApexUris;
    }

    public synchronized Map<String, Set<URI>> getSfdxFiles() {
        HashMap<String, Set<URI>> mapApexUris = Maps.newHashMap();
        this.visitSfdxFiles(new StandardProjectFileVisitor(mapApexUris));
        return mapApexUris;
    }

    public synchronized Map<String, Set<URI>> getClassFiles() {
        HashMap<String, Set<URI>> mapApexUris = Maps.newHashMap();
        this.visitSfdxFiles(new ProjectClassFileVisitor(mapApexUris));
        return mapApexUris;
    }

    public String getNamespaceForFile(Path file, SfdxProject project) {
        return this.getNamespaceForFile(file, project, false);
    }

    private String getNamespaceForFile(Path file, SfdxProject project, boolean getSObjectNamespace) {
        String namespace = project.isUnderPackageDirectory(file) ? project.namespace : (this.isUnderReferencedPackages(file, project) ? this.getReferencedPackageNamespace(file, project) : (getSObjectNamespace && this.isSObject(file.toString()) ? SfdxProjects.getNamespaceForSObject(file.toString()) : ""));
        return namespace != null ? namespace : "";
    }

    public static String getNamespaceForSObject(String filePathString) {
        String[] splitName;
        String className;
        String[] splitPath = filePathString.split("/");
        String namespace = "";
        if (splitPath.length > 0 && (className = splitPath[splitPath.length - 1].toLowerCase()).endsWith(".cls") && (splitName = className.split("__")).length > 2) {
            namespace = splitName[0];
        }
        return namespace;
    }

    public Path getStandardObjectsDir() {
        return this.getStandardObjectsDir(((ServerSetup)this.serverSetupProvider.get()).getRootPath());
    }

    public Path getCustomObjectsDir() {
        return this.getCustomObjectsDir(((ServerSetup)this.serverSetupProvider.get()).getRootPath());
    }

    public Path getSObjectsDir() {
        return this.getSObjectsDir(((ServerSetup)this.serverSetupProvider.get()).getRootPath());
    }

    private Path getStandardObjectsDir(String rootPath) {
        return Paths.get(rootPath, ".sfdx", "tools", "sobjects", "standardObjects");
    }

    private Path getCustomObjectsDir(String rootPath) {
        return Paths.get(rootPath, ".sfdx", "tools", "sobjects", "customObjects");
    }

    private Path getSObjectsDir(String rootPath) {
        return Paths.get(rootPath, ".sfdx", "tools", "sobjects");
    }

    public Path getSfdxProjectPath() {
        return Paths.get(((ServerSetup)this.serverSetupProvider.get()).getRootPath(), "sfdx-project.json");
    }

    public boolean isSObject(String filePathString) {
        return filePathString.contains(this.getStandardObjectsDir().toString()) || filePathString.contains(this.getCustomObjectsDir().toString());
    }

    private synchronized void visitSfdxFiles(SfdxProject sfdxProject, ProjectFileVisitor visitor) {
        Path referencedPackagesRoot;
        String projectNamespace = sfdxProject.namespace;
        if (sfdxProject.packageDirectories != null) {
            for (SfdxProjectPOJO.PackageDirectoriesPOJO pkg : sfdxProject.packageDirectories) {
                if (pkg.path == null) continue;
                Path pkgPath = Paths.get(((ServerSetup)this.serverSetupProvider.get()).getRootPath(), pkg.path);
                try {
                    Files.walkFileTree(pkgPath, new PackagesFileVisitor(projectNamespace, visitor));
                }
                catch (IOException ioe) {
                    logger.error("Failed to retrieve contents of {}", (Object)pkgPath, (Object)ioe);
                }
            }
        }
        if (Files.exists(referencedPackagesRoot = this.getInstalledPackagesFolder(sfdxProject), new LinkOption[0])) {
            try {
                File[] installedPackages;
                for (File installedPackage : installedPackages = new File(referencedPackagesRoot.toString()).listFiles()) {
                    if (!installedPackage.isDirectory()) continue;
                    String namespace = this.getInstalledPackageNamespace(installedPackage.toPath());
                    Files.walkFileTree(installedPackage.toPath(), new PackagesFileVisitor(namespace, visitor));
                }
            }
            catch (IOException ioe) {
                logger.error("Failed to retrieve contents of {}", (Object)referencedPackagesRoot, (Object)ioe);
            }
        }
    }

    public Map<String, Set<URI>> getSObjects(Path SObjectsPath) {
        HashMap<String, Set<URI>> sobjectUris = Maps.newHashMap();
        if (Files.exists(SObjectsPath, new LinkOption[0])) {
            sobjectUris.clear();
            try {
                Files.walkFileTree(SObjectsPath, new SObjectsFileVisitor(sobjectUris));
            }
            catch (IOException ioe) {
                logger.error("Failed to retrieve contents of {}", (Object)SObjectsPath, (Object)ioe);
            }
        }
        return sobjectUris;
    }

    private synchronized void visitSfdxFiles(ProjectFileVisitor visitor) {
        Optional<SfdxProject> sfdxProjectOptional = this.constructSfdxProject();
        if (sfdxProjectOptional.isPresent()) {
            SfdxProject sfdxProject = sfdxProjectOptional.get();
            this.visitSfdxFiles(sfdxProject, visitor);
        }
    }

    private boolean isUnderReferencedPackages(Path file, SfdxProject project) {
        Path referencedPackagesRoot = this.getInstalledPackagesFolder(project);
        return file.startsWith(referencedPackagesRoot);
    }

    private String getInstalledPackageNamespace(Path pkgFolder) {
        Path pathToNamespaceFile = Paths.get(pkgFolder.toString(), NAMESPACE_FILE);
        if (Files.exists(pathToNamespaceFile, new LinkOption[0])) {
            try {
                InstalledPackagePOJO installedPackagePojo = (InstalledPackagePOJO)new Gson().fromJson(new String(Files.readAllBytes(pathToNamespaceFile)), InstalledPackagePOJO.class);
                return installedPackagePojo.namespace;
            }
            catch (IOException ioe) {
                return "";
            }
            catch (JsonSyntaxException jse) {
                logger.error("Contents of {} is invalid json", (Object)pathToNamespaceFile, (Object)jse);
                return "";
            }
        }
        return "";
    }

    private String getReferencedPackageNamespace(Path file, SfdxProject project) {
        Path referencedPackagesRoot = this.getInstalledPackagesFolder(project);
        Path relativePathToFile = referencedPackagesRoot.relativize(file);
        Path enclosingPkg = relativePathToFile.subpath(0, 1);
        Path packagePath = Paths.get(referencedPackagesRoot.toString(), enclosingPkg.toString());
        return this.getInstalledPackageNamespace(packagePath);
    }

    private Path getInstalledPackagesFolder(SfdxProject project) {
        return Paths.get(project.getServerSetup().getRootPath(), ".sfdx", "tools", "installed-packages");
    }

    private class InstalledPackagePOJO {
        String namespace;

        private InstalledPackagePOJO() {
        }
    }

    private class SObjectsFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Map<String, Set<URI>> sobjectUris;

        SObjectsFileVisitor(Map<String, Set<URI>> sobjectUris) {
            this.sobjectUris = sobjectUris;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (ApexIndexer.CLS_MATCHER.matches(file)) {
                String namespace = "";
                URI docUri = file.toUri();
                Set<URI> uris = this.sobjectUris.get("");
                if (uris != null) {
                    uris.add(docUri);
                } else {
                    this.sobjectUris.put("", Sets.newHashSet(docUri));
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private class ProjectClassFileVisitor
    implements ProjectFileVisitor {
        final Map<String, Set<URI>> apexUris;

        ProjectClassFileVisitor(Map<String, Set<URI>> apexUris) {
            this.apexUris = apexUris;
        }

        @Override
        public FileVisitResult visitFile(String namespace, Path file, BasicFileAttributes attrs) {
            if (ApexIndexer.CLS_MATCHER.matches(file)) {
                URI docUri = file.toUri();
                Set<URI> uris = this.apexUris.get(namespace);
                if (uris != null) {
                    uris.add(docUri);
                } else {
                    this.apexUris.put(namespace, Sets.newHashSet(docUri));
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private class StandardProjectFileVisitor
    implements ProjectFileVisitor {
        final Map<String, Set<URI>> apexUris;

        StandardProjectFileVisitor(Map<String, Set<URI>> apexUris) {
            this.apexUris = apexUris;
        }

        @Override
        public FileVisitResult visitFile(String namespace, Path file, BasicFileAttributes attrs) {
            if (ApexIndexer.CLS_MATCHER.matches(file) || ApexIndexer.TRG_MATCHER.matches(file)) {
                URI docUri = file.toUri();
                Set<URI> uris = this.apexUris.get(namespace);
                if (uris != null) {
                    uris.add(docUri);
                } else {
                    this.apexUris.put(namespace, Sets.newHashSet(docUri));
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private class PackagesFileVisitor
    extends SimpleFileVisitor<Path> {
        private final String namespace;
        private final ProjectFileVisitor visitor;

        PackagesFileVisitor(String namespace, ProjectFileVisitor visitor) {
            this.visitor = visitor;
            this.namespace = namespace;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            return this.visitor.visitFile(this.namespace, file, attrs);
        }
    }

    static interface ProjectFileVisitor {
        public FileVisitResult visitFile(String var1, Path var2, BasicFileAttributes var3);
    }
}

