/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.PrefixCompletionActivationStrategy;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.testng.collections.Sets;

public class NamesCompletionStrategies {
    public static List<CompletionItem> provideCompletions(TextDocumentPositionParams params, ApexDocumentService documentService, ApexCompilerService compilerService, CompletionActivationFactory factory, NameProcessor processor) {
        Optional<Document> optDoc = documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            PrefixCompletionActivationStrategy strategy = factory.createPrefixBasedStrategy((Document)doc, params.getPosition());
            if (strategy.shouldSuggestTopLevel()) {
                CodeUnit codeUnit = CodeUnits.getMatchingElement(compilerService.addSources((Document)doc).compileByPassValidation(), doc.getUri().toString());
                UserClassVisitor userClassVisitor = new UserClassVisitor();
                codeUnit.additionalValidate(userClassVisitor);
                Collection<UserClass> innerClasses = userClassVisitor.getInnerClasses();
                Compilation compilation = codeUnit.getNode();
                TypeInfo compiledType = compilation.getDefiningType();
                processor.processClass(compiledType, items);
                for (UserClass innerClass : innerClasses) {
                    processor.processClass(innerClass.getDefiningType(), items);
                }
            }
        });
        return NamesCompletionStrategies.dedup(items);
    }

    public static boolean isImplicitInit(MethodInfo methodInfo) {
        String canonicalName = methodInfo.getCanonicalName();
        return Objects.equals(canonicalName, "<init>") || Objects.equals(canonicalName, "<clinit>");
    }

    public static boolean isBaseMethod(MethodInfo methodInfo) {
        return methodInfo.getDefiningType().getApexName().equalsIgnoreCase("System.ApexBaseClass");
    }

    public static boolean isObjectMethod(MethodInfo methodInfo) {
        return methodInfo.getDefiningType().getApexName().equalsIgnoreCase("Object");
    }

    public static boolean isCloneMethod(MethodInfo methodInfo, TypeInfo definingType) {
        return methodInfo.getCanonicalName().equalsIgnoreCase("clone") && !(definingType instanceof SObjectTypeInfo);
    }

    public static boolean isFilteredOutMethod(MethodInfo methodInfo, TypeInfo definingType) {
        return NamesCompletionStrategies.isImplicitInit(methodInfo) || NamesCompletionStrategies.isBaseMethod(methodInfo) || NamesCompletionStrategies.isObjectMethod(methodInfo) || NamesCompletionStrategies.isCloneMethod(methodInfo, definingType);
    }

    private static List<CompletionItem> dedup(List<CompletionItem> items) {
        return items.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CompletionItem>(Comparator.comparing(CompletionItem::getLabel))), ArrayList::new));
    }

    private static final class UserClassVisitor
    extends AstVisitor<AdditionalPassScope> {
        final Set<UserClass> userClasses = Sets.newHashSet();

        private UserClassVisitor() {
        }

        public Collection<UserClass> getInnerClasses() {
            return this.userClasses;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(UserClass node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            if (!TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                this.userClasses.add(node);
            }
        }
    }

    public static interface NameProcessor {
        public void processClass(TypeInfo var1, List<CompletionItem> var2);
    }
}

