/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.tests;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.tests.TestService;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.tests.TestMethod;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.utils.SfdxProjects;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.eclipse.lsp4j.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StandardTestService
implements TestService {
    private static final Logger logger = LoggerFactory.getLogger(StandardTestService.class);
    private final ApexDocumentService apexDocumentService;
    private final ApexCompilerService compilerService;
    private final SfdxProjects sfdxProjectUtil;

    @Inject
    public StandardTestService(ApexDocumentService apexDocumentService, ApexCompilerService compilerService, SfdxProjects sfdxProjectUtil) {
        this.apexDocumentService = apexDocumentService;
        this.compilerService = compilerService;
        this.sfdxProjectUtil = sfdxProjectUtil;
    }

    @Override
    public CompletableFuture<List<TestMethod>> getTestMethods() {
        ArrayList result = Lists.newArrayList();
        Map<String, Set<URI>> apexUris = this.sfdxProjectUtil.getClassFiles();
        for (Map.Entry<String, Set<URI>> entry : apexUris.entrySet()) {
            for (URI apexUri : entry.getValue()) {
                try {
                    Optional<Document> optDoc = this.apexDocumentService.retrieve(apexUri);
                    optDoc.ifPresent(doc -> {
                        Visitor visitor = new Visitor(result, doc.getUri());
                        CodeUnit codeUnit = CodeUnits.getMatchingElement(this.compilerService.addSourceFiles(SourceFile.builder().setBody(doc.getSource()).setKnownName(doc.getUri().toString()).setNamespace(Namespaces.create((String)entry.getKey())).build()).compileByPassValidation(), doc.getUri().toString());
                        codeUnit.additionalValidate(visitor);
                    });
                }
                catch (Exception e) {
                    logger.error("Error trying to get test method info", (Throwable)e);
                }
            }
        }
        return CompletableFuture.completedFuture(result);
    }

    static final class Visitor
    extends AstVisitor<AdditionalPassScope> {
        private final List<TestMethod> testMethods;
        private final URI file;

        Visitor(List<TestMethod> testMethods, URI file) {
            this.testMethods = testMethods;
            this.file = file;
        }

        @Override
        public boolean visit(UserClass node, AdditionalPassScope scope) {
            return true;
        }

        @Override
        public void visitEnd(Method node, AdditionalPassScope scope) {
            MethodInfo methodInfo = node.getMethodInfo();
            if (methodInfo != null && methodInfo.getModifiers().isTest()) {
                String parentName = methodInfo.getDefiningType().getApexName();
                Location loc = Locations.from(this.file, node.getLoc());
                TestMethod testMethod = new TestMethod(methodInfo.getName(), parentName, loc);
                this.testMethods.add(testMethod);
            }
        }
    }
}

