/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.services;

import apex.jorje.lsp.api.codeActions.CodeActionsProvider;
import apex.jorje.lsp.api.codeLenses.CodeLensProvider;
import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.definition.DefinitionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.document.DocumentLifecycleHandler;
import apex.jorje.lsp.api.references.ReferenceStrategy;
import apex.jorje.lsp.api.rename.RenameProvider;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.visitors.StandardDocumentSymbolVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StandardTextDocumentService
implements TextDocumentService {
    private static final Logger logger = LoggerFactory.getLogger(StandardTextDocumentService.class);
    private final ApexDocumentService sourceService;
    private final ApexCompilerService compilerService;
    private final DocumentLifecycleHandler documentHandler;
    private final DefinitionStrategy definitionStrategy;
    private final ReferenceStrategy referenceStrategy;
    private final VisitorFactory visitorFactory;
    private final CompletionStrategy completionAggregator;
    private final CodeActionsProvider codeActionProvider;
    private final CodeLensProvider codeLensProvider;
    private final RenameProvider renameProvider;

    @Inject
    public StandardTextDocumentService(ApexDocumentService sourceService, ApexCompilerService compilerService, DocumentLifecycleHandler documentHandler, CompletionStrategy completionAggregator, DefinitionStrategy definitionStrategy, ReferenceStrategy referenceStrategy, VisitorFactory visitorFactory, CodeActionsProvider codeActionProvider, CodeLensProvider codeLensProvider, RenameProvider renameProvider) {
        this.sourceService = sourceService;
        this.compilerService = compilerService;
        this.documentHandler = documentHandler;
        this.completionAggregator = completionAggregator;
        this.definitionStrategy = definitionStrategy;
        this.referenceStrategy = referenceStrategy;
        this.visitorFactory = visitorFactory;
        this.codeActionProvider = codeActionProvider;
        this.codeLensProvider = codeLensProvider;
        this.renameProvider = renameProvider;
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        logger.info("Completion requested for {} at {}", (Object)params.getTextDocument().getUri(), (Object)params.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> Either.forRight((Object)new CompletionList(false, this.completionAggregator.provideCompletions((TextDocumentPositionParams)params))));
    }

    @Nullable
    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem completionItem) {
        return null;
    }

    @Nullable
    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        return null;
    }

    @Nullable
    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams textDocumentPositionParams) {
        return null;
    }

    public CompletableFuture<List<? extends Location>> definition(TextDocumentPositionParams params) {
        logger.info("Definition requested for {} at {}", (Object)params.getTextDocument().getUri(), (Object)params.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> this.definitionStrategy.provideDefinition(params));
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams referenceParams) {
        logger.info("References requested for {} at {}", (Object)referenceParams.getTextDocument().getUri(), (Object)referenceParams.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> this.referenceStrategy.provideReferences((TextDocumentPositionParams)referenceParams));
    }

    @Nullable
    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams textDocumentPositionParams) {
        return null;
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        Optional<Document> optDoc = this.sourceService.retrieve(uri);
        ArrayList symbols = new ArrayList();
        if (optDoc.isPresent()) {
            Document doc = optDoc.get();
            StandardDocumentSymbolVisitor visitor = this.generateDocumentSymbols(uri, doc);
            return CompletableFuture.supplyAsync(() -> visitor.getSymbolInformation().stream().map(s -> Either.forLeft((Object)s)).collect(Collectors.toList()));
        }
        return CompletableFuture.completedFuture(symbols.stream().map(s -> Either.forLeft((Object)s)).collect(Collectors.toList()));
    }

    @Nullable
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams codeActionParams) {
        logger.info("CodeActions requested for {} at {}", (Object)codeActionParams.getTextDocument().getUri(), (Object)codeActionParams.getRange());
        return CompletableFutures.computeAsync(cancelChecker -> this.codeActionProvider.provideCodeActions(codeActionParams));
    }

    @Nullable
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams codeLensParams) {
        logger.info("CodeLens requested for {}", (Object)codeLensParams.getTextDocument().getUri());
        return CompletableFutures.computeAsync(cancelChecker -> this.codeLensProvider.provideCodeLenses(codeLensParams));
    }

    @Nullable
    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens codeLens) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams documentFormattingParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams documentRangeFormattingParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams documentOnTypeFormattingParams) {
        return null;
    }

    @Nullable
    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        logger.info("Definition requested for {} at {}", (Object)params.getTextDocument().getUri(), (Object)params.getPosition());
        return CompletableFutures.computeAsync(cancelChecker -> this.renameProvider.provideRename(params));
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        logger.debug("Document {} opened", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidOpen(params);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        logger.debug("Document {} changed", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidChange(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        logger.debug("Document {} closed", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidClose(params);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        logger.debug("Document {} saved", (Object)params.getTextDocument().getUri());
        this.documentHandler.handleDidSave(params);
    }

    @VisibleForTesting
    public StandardDocumentSymbolVisitor generateDocumentSymbols(URI uri, Document doc) {
        StandardDocumentSymbolVisitor visitor = this.visitorFactory.createDocumentSymbolVisitor(uri);
        CodeUnit codeUnit = CodeUnits.getMatchingElement(this.compilerService.addSources(doc).compileByPassValidation(), doc.getUri().toString());
        codeUnit.additionalValidate(visitor);
        return visitor;
    }
}

