/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.services;

import apex.jorje.data.Locations;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.symbols.CachingSymbolProvider;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.common.TestAccessEvaluator;
import apex.jorje.semantic.common.TestQueryValidators;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.CompilerOperation;
import apex.jorje.semantic.compiler.CompilerStage;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.ValidationSettings;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.NoopCompilerProgressCallback;
import apex.jorje.semantic.compiler.sfdc.QueryValidator;
import com.google.common.collect.MoreLists;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardCompilerService
implements ApexCompilerService {
    private static final Logger logger = LoggerFactory.getLogger(StandardCompilerService.class);
    private final List<SourceFile> sources = new ArrayList<SourceFile>();
    private final CachingSymbolProvider symbolProvider;
    private final AccessEvaluator accessEvaluator;
    private final QueryValidator queryValidator;
    private AstVisitor<AdditionalPassScope> visitor;
    private final ApexDocumentService docService;

    @Inject
    public StandardCompilerService(CachingSymbolProvider symbolProvider, ApexDocumentService docService) {
        this.symbolProvider = symbolProvider;
        this.accessEvaluator = new TestAccessEvaluator();
        this.queryValidator = new TestQueryValidators.Noop();
        this.docService = docService;
        Locations.useIndexFactory();
    }

    @Override
    public ApexCompilerService setVisitor(AstVisitor<AdditionalPassScope> visitor) {
        this.visitor = visitor;
        return this;
    }

    private ApexCompilerService addDocumentSources(List<Document> documents) {
        this.sources.addAll(documents.stream().map(doc -> SourceFile.builder().setBody(doc.getSource()).setKnownName(doc.getUri().toString()).setNamespace(Namespaces.create(this.docService.retrieveNamespace(doc.getUri()))).build()).collect(Collectors.toList()));
        return this;
    }

    @Override
    public ApexCompilerService addSources(Document ... documents) {
        return this.addDocumentSources(MoreLists.asImmutableList(documents));
    }

    @Override
    public ApexCompilerService addSourceFiles(SourceFile ... sourceFiles) {
        this.addSourceFiles(MoreLists.asImmutableList(sourceFiles));
        return this;
    }

    @Override
    public ApexCompilerService addSourceFiles(List<SourceFile> sourceFiles) {
        this.sources.addAll(sourceFiles);
        return this;
    }

    @Override
    public ApexCompiler createCompiler() {
        CompilationInput input = new CompilationInput(this.sources, this.symbolProvider, this.accessEvaluator, this.queryValidator, this.visitor, NoopCompilerProgressCallback.get());
        ValidationSettings validationSettings = ValidationSettings.builder().setValidationBehavior(ValidationSettings.ValidationBehavior.COLLECT_MULTIPLE_ERRORS).build();
        return ApexCompiler.builder().setInput(input).setValidationSettings(validationSettings).build();
    }

    @Override
    public List<CodeUnit> compile() {
        List<CodeUnit> codeUnits;
        try {
            ApexCompiler compiler = this.createCompiler();
            codeUnits = compiler.compile(CompilerStage.ADDITIONAL_VALIDATE);
        }
        finally {
            this.sources.clear();
        }
        return codeUnits;
    }

    @Override
    public List<CodeUnit> compileByPassValidation() {
        List<CodeUnit> codeUnits;
        try {
            ApexCompiler compiler = this.createCompiler();
            codeUnits = compiler.compile(CompilerStage.POST_TYPE_RESOLVE);
            this.callAdditionalPassVisitor(compiler);
        }
        finally {
            this.sources.clear();
        }
        return codeUnits;
    }

    private void callAdditionalPassVisitor(ApexCompiler compiler) {
        try {
            List allUnits = (List)FieldUtils.readDeclaredField((Object)compiler, (String)"allUnits", (boolean)true);
            for (CodeUnit unit : allUnits) {
                Method getOperation = CompilerStage.ADDITIONAL_VALIDATE.getDeclaringClass().getDeclaredMethod("getOperation", new Class[0]);
                getOperation.setAccessible(true);
                CompilerOperation operation = (CompilerOperation)getOperation.invoke((Object)CompilerStage.ADDITIONAL_VALIDATE, new Object[0]);
                operation.invoke(compiler.getCompilerContext(), unit);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Failed to invoke additional validator", (Throwable)e);
        }
    }
}

