/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.rename;

import apex.common.base.MoreStrings;
import apex.common.collect.MoreCollections;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.TypeRefs;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.references.ReferenceLocationProvider;
import apex.jorje.lsp.api.rename.RenameHandler;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.rename.RenameUtil;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.BooleanScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.ExceptionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameFactory;
import apex.jorje.semantic.symbol.type.naming.TypeNameUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.MoreCollectors;
import com.google.inject.Provider;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class TypeRenameHandler
implements RenameHandler {
    private final TypeInfo type;
    private final RenameParams renameParams;
    private final ReferenceLocationProvider referenceLocationProvider;
    private final Provider<ApexIndex> apexIndexProvider;
    private final String newApexName;
    private final Optional<CodeUnit> sourceUnit;

    TypeRenameHandler(TypeInfo type, RenameParams renameParams, ApexCompilerService compilerService, ReferenceLocationProvider referenceLocationProvider, Provider<ApexIndex> apexIndexProvider, ApexDocumentService documentService) {
        this.type = type;
        this.renameParams = renameParams;
        this.referenceLocationProvider = referenceLocationProvider;
        this.apexIndexProvider = apexIndexProvider;
        this.newApexName = TypeNameFactory.createApexName(type.getNamespace(), type.getEnclosingType(), type.getUnitType(), renameParams.getNewName());
        List<Location> referenceLocations = referenceLocationProvider.getReferenceLocations((ApexIndex)apexIndexProvider.get(), type);
        Map<String, List<Location>> uriToLocations = referenceLocations.stream().collect(Collectors.groupingBy(Location::getUri));
        Document[] sourceDocuments = (Document[])uriToLocations.keySet().stream().map(u -> documentService.retrieve(URI.create(u))).filter(Optional::isPresent).map(Optional::get).toArray(Document[]::new);
        List<CodeUnit> referenceCodeUnits = compilerService.addSources(sourceDocuments).compile();
        this.sourceUnit = TypeInfoUtil.isTopLevel(type) ? Optional.of((CodeUnit)referenceCodeUnits.stream().filter(c -> MoreStrings.equalsIgnoreCase(c.getType().getApexName(), type.getApexName()) && c.getType().getUnitType() == type.getUnitType()).collect(MoreCollectors.onlyElement())) : Optional.empty();
    }

    @Override
    public List<Either<TextDocumentEdit, ResourceOperation>> getDocumentChanges() {
        List<Location> locations = this.referenceLocationProvider.getReferenceLocations((ApexIndex)this.apexIndexProvider.get(), this.type);
        Map<String, List<Location>> uriToLocations = locations.stream().collect(Collectors.groupingBy(Location::getUri));
        HashMap uriToTextEdits = new HashMap();
        for (Map.Entry<String, List<Location>> entry : uriToLocations.entrySet()) {
            List edits = entry.getValue().stream().map(l -> new TextEdit(l.getRange(), this.renameParams.getNewName())).collect(Collectors.toList());
            uriToTextEdits.put(entry.getKey(), edits);
        }
        List constructors = this.type.methods().all().stream().filter(MethodInfo::isConstructor).collect(Collectors.toList());
        for (MethodInfo constructor : constructors) {
            List<Location> constructorReferences = this.referenceLocationProvider.getReferenceLocations((ApexIndex)this.apexIndexProvider.get(), constructor);
            Map<String, List<Location>> uriToLocationsConst = constructorReferences.stream().collect(Collectors.groupingBy(Location::getUri));
            for (Map.Entry<String, List<Location>> entry : uriToLocationsConst.entrySet()) {
                List edits = entry.getValue().stream().map(l -> new TextEdit(l.getRange(), this.renameParams.getNewName())).collect(Collectors.toList());
                if (uriToTextEdits.containsKey(entry.getKey())) {
                    ((List)uriToTextEdits.get(entry.getKey())).addAll(edits);
                    continue;
                }
                uriToTextEdits.put(entry.getKey(), edits);
            }
        }
        List<Either<TextDocumentEdit, ResourceOperation>> list = uriToTextEdits.keySet().stream().map(uri -> Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), (List)uriToTextEdits.get(uri)))).collect(Collectors.toList());
        this.sourceUnit.ifPresent(unit -> {
            String oldUri = unit.getSourceFile().getKnownName();
            String newUri = RenameUtil.renameFileUri(oldUri, this.renameParams.getNewName());
            documentChanges.add(Either.forRight((Object)new RenameFile(oldUri, newUri)));
            documentChanges.add(Either.forRight((Object)new RenameFile(oldUri.concat(RenameUtil.METADATA_SUFFIX), newUri.concat(RenameUtil.METADATA_SUFFIX))));
        });
        return list;
    }

    @Override
    public Optional<String> getConflictError() {
        if (this.isTypePresent()) {
            return Optional.of(I18nSupport.getLabel("duplicate.type.name", this.renameParams.getNewName()));
        }
        if (!TypeInfoUtil.isInnerType(this.type) && this.hasConflictWithInnerClass()) {
            return Optional.of(I18nSupport.getLabel("new.name.conflict.inner"));
        }
        if (TypeInfoUtil.isInnerType(this.type)) {
            if (MoreStrings.equalsIgnoreCase(this.type.getEnclosingType().getCodeUnitDetails().getName(), this.renameParams.getNewName())) {
                return Optional.of(I18nSupport.getLabel("new.inner.type.name.conflict.super.type"));
            }
            if (this.hasConflictWithSuperType(this.renameParams.getNewName())) {
                return Optional.of(I18nSupport.getLabel("new.inner.type.name.conflict.super.type"));
            }
            if (this.hasConflictWithInterface(this.renameParams.getNewName())) {
                return Optional.of(I18nSupport.getLabel("new.inner.type.name.conflict.interface"));
            }
        }
        return Optional.empty();
    }

    private boolean hasConflictWithInnerClass() {
        return BooleanScope.evaluate(this.sourceUnit.get().getNode(), new AstVisitor<BooleanScope>(){

            @Override
            protected boolean defaultVisit() {
                return true;
            }

            @Override
            public void visitEnd(UserClass userClass, BooleanScope scope) {
                if (userClass.getDefiningType() != null && TypeInfoUtil.isInnerType(userClass.getDefiningType()) && TypeRenameHandler.this.type.getUnitType() != UnitType.TRIGGER && MoreStrings.equalsIgnoreCase(userClass.getDefiningType().getCodeUnitDetails().getName(), TypeRenameHandler.this.renameParams.getNewName())) {
                    scope.setValue(true);
                }
            }
        }, false);
    }

    private boolean hasConflictWithSuperType(String newName) {
        if (this.type.getEnclosingType().parents().superType() != null && this.type.getEnclosingType().getCodeUnitDetails().getSuperTypeRef().isPresent()) {
            return this.checkForConflictTypeRef(newName, this.type.getEnclosingType().getCodeUnitDetails().getSuperTypeRef().get());
        }
        return false;
    }

    private boolean hasConflictWithInterface(String newName) {
        if (!MoreCollections.isNullOrEmpty(this.type.getEnclosingType().parents().immediateInterfaces())) {
            for (TypeRef interfaceTypeRef : this.type.getEnclosingType().getCodeUnitDetails().getInterfaceTypeRefs()) {
                if (!this.checkForConflictTypeRef(newName, interfaceTypeRef)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkForConflictTypeRef(final String newName, TypeRef typeRef) {
        return typeRef.accept(new TypeRef.Visitor<Boolean>(){

            @Override
            public Boolean visit(TypeRefs.JavaTypeRef typeRef) {
                return false;
            }

            @Override
            public Boolean visit(TypeRefs.ClassTypeRef typeRef) {
                return typeRef.getNames().size() == 1 && MoreStrings.equalsIgnoreCase(typeRef.getNames().get(0).getValue(), newName);
            }

            @Override
            public Boolean visit(TypeRefs.ArrayTypeRef typeRef) {
                return false;
            }
        });
    }

    @Override
    public Optional<String> canBeRenamed() {
        return this.type.getCodeUnitDetails().isApexSourceBased() ? Optional.empty() : Optional.of(I18nSupport.getLabel("cannot.rename"));
    }

    @Override
    public Optional<String> isIdentifierNameInvalid() {
        if (this.hasInvalidIdentifierName()) {
            return Optional.of(I18nSupport.getLabel("new.name.invalid.identifier"));
        }
        if (ExceptionTypeInfoUtil.isException(this.type) && !TypeNameUtil.isException(this.renameParams.getNewName())) {
            return Optional.of(I18nSupport.getLabel("new.name.invalid.exception"));
        }
        if (!ExceptionTypeInfoUtil.isException(this.type) && TypeNameUtil.isException(this.renameParams.getNewName().toLowerCase())) {
            return Optional.of(I18nSupport.getLabel("new.name.cannot.end.exception"));
        }
        return Optional.empty();
    }

    private boolean hasInvalidIdentifierName() {
        return IdentifierValidator.get().validate(this.type, this.renameParams.getNewName(), this.getTypeKind(), TypeInfoUtil.isTopLevel(this.type), false).hasError();
    }

    private boolean isTypePresent() {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            ApexTypeId apexId = apexIndex.findExactTypeId(this.newApexName);
            boolean bl = apexId != null && apexId.getType().getUnitType().getString().equals(this.type.getUnitType().name());
            return bl;
        }
    }

    private IdentifierValidator.Type getTypeKind() {
        switch (this.type.getUnitType()) {
            case CLASS: {
                return IdentifierValidator.Type.CLASS;
            }
            case TRIGGER: {
                return IdentifierValidator.Type.TRIGGER;
            }
            case ENUM: {
                return IdentifierValidator.Type.ENUM;
            }
            case INTERFACE: {
                return IdentifierValidator.Type.INTERFACE;
            }
        }
        throw new UnexpectedCodePathException(this.type.getUnitType().name() + " kind cannot be handled by TypeRenameHandler ");
    }
}

