/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.rename;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.error.ErrorHandler;
import apex.jorje.lsp.api.references.ReferenceLocationProvider;
import apex.jorje.lsp.api.rename.RenameHandler;
import apex.jorje.lsp.api.rename.RenameProvider;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.rename.FieldRenameHandler;
import apex.jorje.lsp.impl.rename.LocalRenameHandler;
import apex.jorje.lsp.impl.rename.MethodRenameHandler;
import apex.jorje.lsp.impl.rename.TypeRenameHandler;
import apex.jorje.lsp.impl.visitors.ReferenceSourceVisitor;
import apex.jorje.lsp.impl.workspace.ServerSetup;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.base.Stopwatch;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRenameProvider
implements RenameProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardRenameProvider.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final Provider<ApexIndex> apexIndexProvider;
    private final Provider<ServerSetup> serverSetupProvider;
    private final ReferenceLocationProvider referenceLocationProvider;
    private final VisitorFactory visitorFactory;
    private final ErrorHandler errorHandler;

    @Inject
    public StandardRenameProvider(ApexCompilerService compilerService, ApexDocumentService documentService, Provider<ApexIndex> apexIndexProvider, Provider<ServerSetup> serverSetupProvider, ReferenceLocationProvider referenceLocationProvider, VisitorFactory visitorFactory, ErrorHandler errorHandler) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.apexIndexProvider = apexIndexProvider;
        this.serverSetupProvider = serverSetupProvider;
        this.referenceLocationProvider = referenceLocationProvider;
        this.visitorFactory = visitorFactory;
        this.errorHandler = errorHandler;
    }

    @Override
    public WorkspaceEdit provideRename(RenameParams params) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        URI docUri = URI.create(params.getTextDocument().getUri());
        Optional<Document> optDoc = this.documentService.retrieve(docUri);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        optDoc.ifPresent(doc -> {
            try {
                int lineOffset = doc.getLineOffset(params.getPosition().getLine());
                int offset = lineOffset + params.getPosition().getCharacter();
                ReferenceSourceVisitor visitor = new ReferenceSourceVisitor(offset);
                List<CodeUnit> codeUnits = this.compilerService.setVisitor(visitor).addSources((Document)doc).compile();
                Optional<Either<TypeInfo, Member>> refSymbol = visitor.getSymbol();
                CodeUnit codeUnit = codeUnits.get(0);
                if (!refSymbol.isPresent()) {
                    return;
                }
                Optional<RenameHandler> renameHandler = this.getRenameHandler(refSymbol.get(), params, codeUnit);
                if (!renameHandler.isPresent()) {
                    return;
                }
                Optional<String> canRename = renameHandler.get().canBeRenamed();
                if (canRename.isPresent()) {
                    this.errorHandler.showError(((ServerSetup)this.serverSetupProvider.get()).getLanguageClient(), canRename.get());
                    return;
                }
                Optional<String> identifierInvalidError = renameHandler.get().isIdentifierNameInvalid();
                if (identifierInvalidError.isPresent()) {
                    this.errorHandler.showError(((ServerSetup)this.serverSetupProvider.get()).getLanguageClient(), identifierInvalidError.get());
                    return;
                }
                Optional<String> conflictError = renameHandler.get().getConflictError();
                if (conflictError.isPresent()) {
                    this.errorHandler.showError(((ServerSetup)this.serverSetupProvider.get()).getLanguageClient(), conflictError.get());
                    return;
                }
                workspaceEdit.setDocumentChanges(renameHandler.get().getDocumentChanges());
            }
            catch (BadLocationException exception) {
                logger.error("Encountered a bad location while providing rename", (Throwable)exception);
            }
        });
        stopwatch.stop();
        logger.info("Rename for {} took {} ms.", (Object)params.getTextDocument().getUri(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return workspaceEdit;
    }

    private Optional<RenameHandler> getRenameHandler(Either<TypeInfo, Member> symbol, RenameParams params, CodeUnit codeUnit) {
        if (symbol.getLeft() != null) {
            return Optional.of(new TypeRenameHandler((TypeInfo)symbol.getLeft(), params, this.compilerService, this.referenceLocationProvider, this.apexIndexProvider, this.documentService));
        }
        if (symbol.getRight() != null) {
            Member member = (Member)symbol.getRight();
            switch (member.getMemberType()) {
                case LOCAL: {
                    return Optional.of(new LocalRenameHandler((LocalInfo)member, codeUnit, params));
                }
                case METHOD: {
                    MethodInfo method = (MethodInfo)member;
                    return method.isConstructor() ? Optional.of(new TypeRenameHandler(method.getDefiningType(), params, this.compilerService, this.referenceLocationProvider, this.apexIndexProvider, this.documentService)) : Optional.of(new MethodRenameHandler(method, params, this.compilerService, this.apexIndexProvider, this.referenceLocationProvider, this.documentService, this.visitorFactory));
                }
                case PROPERTY: 
                case FIELD: 
                case DYNAMIC: {
                    return Optional.of(new FieldRenameHandler((Variable)member, params, this.compilerService, this.apexIndexProvider, this.referenceLocationProvider, this.documentService, this.visitorFactory));
                }
            }
            logger.error("Unknown member type encountered when handling renames: " + member.getMemberType().name());
            throw new UnexpectedCodePathException("Unexpected member type for rename handler: " + member.getMemberType().name());
        }
        return Optional.empty();
    }
}

