/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.references;

import apex.jorje.data.Location;
import apex.jorje.lsp.api.references.ReferenceLocationProvider;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexReference;
import apex.jorje.lsp.impl.index.node.ApexResourceFile;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.index.symbol.VirtualStandardTypeInfo;
import apex.jorje.lsp.impl.references.ReferenceInfo;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.utils.TypeInfoCache;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.member.method.signature.SignatureEquivalence;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.resolver.StandardSymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.Sets;
import com.google.inject.Provider;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.core.nd.IProgressMonitor;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NullProgressMonitor;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class DBBackedReferenceProvider
implements ReferenceLocationProvider {
    @Override
    public List<org.eclipse.lsp4j.Location> getReferenceLocations(ApexIndex apexIndex, TypeInfo type) {
        return this.getReferenceLocations(apexIndex, type.getBytecodeName());
    }

    @Override
    public List<org.eclipse.lsp4j.Location> getReferenceLocations(ApexIndex apexIndex, Member member) {
        return this.getReferenceLocations(apexIndex, DBBackedReferenceProvider.getFullName(member));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNdReferences(ApexResourceFile resourceFile, List<ReferenceInfo> referenceInfos, Nd nd) {
        nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
        try {
            referenceInfos.stream().map(ref -> new DBReferenceInfo(ref.getTypeOrMember(), ref.getLocation())).distinct().forEach(dbRef -> new ApexReference(nd, resourceFile, dbRef.getReferenceString(), dbRef.getLocation()));
        }
        finally {
            nd.releaseWriteLock();
        }
    }

    private List<org.eclipse.lsp4j.Location> getReferenceLocations(ApexIndex apexIndex, String referenceSource) {
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            List<org.eclipse.lsp4j.Location> list = apexIndex.findReferencesBySymbolName(referenceSource).stream().map(ref -> Locations.from(URI.create(ref.getDocUri().getString()), ref)).collect(Collectors.toList());
            return list;
        }
    }

    private static String getFullName(Member member) {
        switch (member.getMemberType()) {
            case LOCAL: {
                return member.getName();
            }
            case METHOD: {
                return ((MethodInfo)member).getSignature().toString();
            }
            case FIELD: {
                FieldInfo fieldInfo = (FieldInfo)member;
                return String.join((CharSequence)".", fieldInfo.getDefiningType().getBytecodeName(), fieldInfo.getBytecodeName());
            }
        }
        return String.join((CharSequence)".", member.getDefiningType().getBytecodeName(), member.getName());
    }

    @Override
    public List<org.eclipse.lsp4j.Location> getInstanceMethodLocations(Provider<ApexIndex> apexIndexProvider, ApexCompilerService compilerService, MethodInfo method) {
        return this.getInstanceMethodReferencesFromType(apexIndexProvider, compilerService, method.getDefiningType(), method.getSignature(), Sets.newHashSet("Object", "System.ApexBaseClass"));
    }

    private List<org.eclipse.lsp4j.Location> getInstanceMethodReferencesFromType(Provider<ApexIndex> apexIndexProvider, ApexCompilerService compilerService, TypeInfo definingType, Signature testSignature, Set<String> visitedTypes) {
        ArrayList<org.eclipse.lsp4j.Location> references = new ArrayList<org.eclipse.lsp4j.Location>();
        if (definingType != null && !visitedTypes.contains(definingType.getApexName())) {
            visitedTypes.add(definingType.getApexName());
            references.addAll(this.findReferences((ApexIndex)apexIndexProvider.get(), definingType, testSignature));
            TypeInfo parentType = definingType.parents().superType();
            if (parentType != null) {
                references.addAll(this.getInstanceMethodReferencesFromType(apexIndexProvider, compilerService, parentType, testSignature, visitedTypes));
            }
            List<TypeInfo> interfaces = definingType.parents().immediateInterfaces();
            for (TypeInfo interfaceInfo : interfaces) {
                references.addAll(this.getInstanceMethodReferencesFromType(apexIndexProvider, compilerService, interfaceInfo, testSignature, visitedTypes));
            }
            ApexIndex apexIndex = (ApexIndex)apexIndexProvider.get();
            try (IReader ignored = apexIndex.getNd().acquireReadLock();){
                ApexTypeId currentTypeId = apexIndex.findExactTypeId(definingType.getApexName());
                List<ApexTypeId> currentChildrenAndImplementors = currentTypeId.getChildren();
                currentChildrenAndImplementors.addAll(currentTypeId.getImplementors());
                if (!currentChildrenAndImplementors.isEmpty()) {
                    StandardSymbolResolver symbolResolver = new StandardSymbolResolver(compilerService.createCompiler());
                    for (ApexTypeId currentCI : currentChildrenAndImplementors) {
                        TypeInfo cachedInfo = TypeInfoCache.getTypeInfo(currentCI.getApexName().toString());
                        TypeInfo childInfo = cachedInfo != null ? cachedInfo : new VirtualStandardTypeInfo.Builder(symbolResolver, apexIndexProvider).setApexTypeId(currentCI).buildResolved();
                        references.addAll(this.getInstanceMethodReferencesFromType(apexIndexProvider, compilerService, childInfo, testSignature, visitedTypes));
                    }
                }
            }
            return references;
        }
        return Collections.emptyList();
    }

    private List<org.eclipse.lsp4j.Location> findReferences(ApexIndex apexIndex, TypeInfo definingType, Signature testSignature) {
        ArrayList<org.eclipse.lsp4j.Location> resultHM = new ArrayList<org.eclipse.lsp4j.Location>();
        Optional<String> matchMethodName = this.findMatchMethodName(definingType, testSignature);
        matchMethodName.ifPresent(name -> {
            try (IReader ignored = apexIndex.getNd().acquireReadLock();){
                List items = apexIndex.findReferencesBySymbolName((String)matchMethodName.get()).stream().map(ref -> Locations.from(URI.create(ref.getDocUri().getString()), ref)).collect(Collectors.toList());
                resultHM.addAll(items);
            }
        });
        return resultHM;
    }

    private Optional<String> findMatchMethodName(TypeInfo definingType, Signature testSignature) {
        MethodTable methodTable = definingType.methods();
        Collection<MethodInfo> instanceMethods = methodTable.getInstance();
        for (MethodInfo methodInfo : instanceMethods) {
            if (!SignatureEquivalence.isEquivalent(testSignature, methodInfo.getSignature())) continue;
            return Optional.of(methodInfo.getSignature().toString());
        }
        return Optional.empty();
    }

    private static class DBReferenceInfo {
        final String referenceString;
        final Location location;

        public DBReferenceInfo(Either<TypeInfo, Member> typeOrMember, Location location) {
            this.referenceString = typeOrMember.getLeft() != null ? ((TypeInfo)typeOrMember.getLeft()).getBytecodeName() : DBBackedReferenceProvider.getFullName((Member)typeOrMember.getRight());
            this.location = location;
        }

        public String getReferenceString() {
            return this.referenceString;
        }

        public Location getLocation() {
            return this.location;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.referenceString == null ? 0 : this.referenceString.hashCode());
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DBReferenceInfo other = (DBReferenceInfo)obj;
            if (this.referenceString == null ? other.referenceString != null : !Objects.equals(this.referenceString, other.referenceString)) {
                return false;
            }
            return !(this.location == null ? other.location != null : !Objects.equals(this.location, other.location));
        }
    }
}

