/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.references;

import apex.jorje.lsp.api.references.ReferenceStrategy;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexReferenceStrategyAggregator
implements ReferenceStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ApexReferenceStrategyAggregator.class);
    private final Set<ReferenceStrategy> strategies;

    @Inject
    public ApexReferenceStrategyAggregator(Set<ReferenceStrategy> referenceStrategies) {
        this.strategies = referenceStrategies;
    }

    @Override
    public List<? extends Location> provideReferences(TextDocumentPositionParams params) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList<? extends Location> items = Lists.newArrayList();
        for (ReferenceStrategy strategy : this.strategies) {
            try {
                items.addAll(strategy.provideReferences(params));
            }
            catch (Exception e) {
                logger.error(String.format("Encountered an error with strategy %s", strategy), (Throwable)e);
            }
        }
        stopwatch.stop();
        logger.info("Find References for {} took {} ms.", (Object)params.getTextDocument().getUri(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return items;
    }
}

